/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report;

import com.excentis.products.byteblower.report.CloudUploadResponse;
import com.excentis.products.byteblower.report.EclipseUtil;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportManager;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonReportManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

final class CloudUpload
implements ReportManager {
    private static Logger LOGGER = Logger.getGlobal();
    private static Executor ex = Executors.newCachedThreadPool();

    CloudUpload() {
    }

    public void createReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface pref, GenerateReportListener listener, IProgressMonitor monitor) {
        JsonReportManager json = new JsonReportManager();
        try {
            monitor.beginTask("Uploading to cloud", 0);
            String cloudUrl = pref.getUploadUrl().isEmpty() ? "[EMPTY CLOUD URL]" : pref.getUploadUrl();
            LOGGER.info(() -> String.format("Uploading to cloud url: %s", cloudUrl));
            Uploader uploader = new Uploader(pref.getUploadUrl());
            long uploadCount = json.createPartialReport(reportGeneration, pref).takeWhile(_a -> !monitor.isCanceled()).takeWhile(partial -> {
                monitor.worked(1);
                return uploader.upload((String)partial, pref.getApiKey());
            }).collect(Collectors.counting());
            LOGGER.info(String.format("Upload in %d parts", uploadCount));
            if (uploader.hasReportLink()) {
                listener.onReportExported(reportGeneration, uploader.reportLink(), ReportOutputFormat.html);
            }
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException ex) {
            LOGGER.log(Level.SEVERE, "Unable to upload Report", ex);
        }
    }

    private static byte[] compressedData(String data) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GZIPOutputStream compressed = new GZIPOutputStream(output);){
                ((OutputStream)compressed).write(data.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Unable to compress data", ex);
        }
        return output.toByteArray();
    }

    private static CloudUploadResponse parseReportLink(String response, String baseUrl) throws ParseException {
        LOGGER.info(() -> String.format("response: %s %n", response));
        return CloudUploadResponse.parse(baseUrl, response);
    }

    private static class Uploader {
        private final HttpClient client;
        private URI nextUpload;
        private CloudUploadResponse response;
        private final String baseUrl;

        Uploader(String cloudAddress) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
            this.nextUpload = new URI(cloudAddress).resolve("/api/datasources");
            this.baseUrl = cloudAddress;
            ProxySelector defaultProxy = ProxySelector.getDefault();
            this.client = HttpClient.newBuilder().proxy(defaultProxy).executor(ex).build();
        }

        public String reportLink() {
            if (this.hasReportLink()) {
                return this.response.report;
            }
            return this.baseUrl;
        }

        public boolean hasReportLink() {
            return this.response != null;
        }

        public boolean upload(String data, String apiKey) {
            int code;
            block14: {
                block13: {
                    block12: {
                        if (apiKey != null) break block12;
                        return false;
                    }
                    String sanitizedKey = new String(apiKey.getBytes(StandardCharsets.US_ASCII));
                    HttpRequest.BodyPublisher uploadBody = HttpRequest.BodyPublishers.ofByteArray(CloudUpload.compressedData(data));
                    HttpRequest.Builder reqBuild = HttpRequest.newBuilder().uri(this.nextUpload).header("Content-Type", "application/json").header("accept", "application/json").header("Content-Encoding", "gzip").header("User-Agent", String.format("ByteBlower-RCP/%s", EclipseUtil.version()));
                    try {
                        reqBuild = reqBuild.header("Authorization", "ApiKey " + sanitizedKey);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(Level.SEVERE, "Invalid API key for uploading to Excentis Cloud");
                        return false;
                    }
                    HttpRequest request = reqBuild.POST(uploadBody).expectContinue(true).build();
                    CompletableFuture<HttpResponse<String>> upload = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
                    HttpResponse<String> result = upload.get(60L, TimeUnit.MINUTES);
                    code = result.statusCode();
                    if (200 != code && 201 != code) break block13;
                    String body = result.body();
                    if (this.response == null) {
                        this.response = CloudUpload.parseReportLink(body, this.baseUrl);
                    } else {
                        this.response.parseMore(body);
                    }
                    this.nextUpload = new URI(this.response.postMore);
                    return true;
                }
                if (401 != code) break block14;
                StringBuilder msg = new StringBuilder();
                msg.append("Excentis Cloud does not allow uploads with the configured API key.%n");
                msg.append("Check the config or generate a new key on '%s'.%n");
                LOGGER.severe(() -> String.format(msg.toString(), this.baseUrl, code));
                return false;
            }
            try {
                LOGGER.severe(() -> String.format("Unexpected return code: %d %n", code));
                return false;
            }
            catch (ExecutionException | TimeoutException e) {
                LOGGER.log(Level.SEVERE, "Backend did not respond in time", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Aborting report generation.", e);
                Thread.currentThread().interrupt();
            }
            catch (URISyntaxException | ParseException e) {
                LOGGER.log(Level.SEVERE, "Could not parse backend response", e);
            }
            return false;
        }
    }
}

