/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class CloudUploadResponse {
    private static final Logger LOGGER = Logger.getGlobal();
    final String report;
    String postMore;
    final String baseUrl;

    private CloudUploadResponse(String baseUrl, String reportFragment, String moreFragment) {
        this.report = String.valueOf(baseUrl) + reportFragment;
        this.postMore = String.valueOf(baseUrl) + moreFragment;
        this.baseUrl = baseUrl;
    }

    public void parseMore(String responseBody) throws ParseException {
        Gson jsonParser = new Gson();
        try {
            Map parsed = (Map)jsonParser.fromJson(responseBody, Map.class);
            String moreData = parsed.getOrDefault("postMore", "").replace("/api/", "api/");
            this.postMore = String.valueOf(this.baseUrl) + moreData;
        }
        catch (JsonSyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Did not receive a JSON reply from backend", ex);
            throw new ParseException("Did not receive a JSON reply from backend", 0);
        }
    }

    public static CloudUploadResponse parse(String baseUrl, String responseBody) throws ParseException {
        Gson jsonParser = new Gson();
        try {
            List parsed = (List)jsonParser.fromJson(responseBody, List.class);
            if (!parsed.isEmpty()) {
                Map val = (Map)parsed.get(0);
                String reportFragment = ((String)val.get("report")).replace("/api/", "");
                String moreData = val.getOrDefault("postMore", "").replace("/api/", "api/");
                return new CloudUploadResponse(baseUrl, reportFragment, moreData);
            }
        }
        catch (JsonSyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Did not receive a JSON reply from backend", ex);
            throw new ParseException("Did not receive a JSON reply from backend", 0);
        }
        throw new ParseException("Backend did not include report link", 0);
    }
}

