/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report;

import com.excentis.products.byteblower.report.CloudUpload;
import com.excentis.products.byteblower.report.ReportTemplate_1_x;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportExportedListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtml;
import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtmlV2;
import com.excentis.products.byteblower.report.generator.jasper.manager.ReportManagerJasper;
import com.excentis.products.byteblower.report.generator.plaintext.ReportManagerPlainText;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonReportManager;
import com.excentis.products.byteblower.results.dataprovider.data.BaseEntityManager;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.TestDataReferenceManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Tag;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import com.excentis.products.byteblower.results.postprocessing.PostProcessing;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceCookie;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportGenerator
implements GenerateReportListener {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final long serialVersionUID = 7466880611096772024L;
    private final MetaDataPersistenceController metaDataPersistenceController = MetaDataPersistenceController.getInstance();
    private final BaseEntityManager<Report> reportManager = new BaseEntityManager(Report.class, this.metaDataPersistenceController);
    private List<ReportExportedListener> reportExportedListeners = new ArrayList<ReportExportedListener>();
    private static ReportGenerator reportGenerator = null;

    public static ReportGenerator getInstance() {
        if (reportGenerator == null) {
            reportGenerator = new ReportGenerator();
        }
        return reportGenerator;
    }

    private ReportGenerator() {
    }

    public void addReportExportedListener(ReportExportedListener listener) {
        this.reportExportedListeners.add(listener);
    }

    public void generateReport(Long testDataPersistenceId, ReportPreferencesInterface reportPreferences, IProgressMonitor monitor) {
        TestDataReference testDataReference = this.getTestDataReference(testDataPersistenceId);
        long testId = testDataReference.getId();
        TestDataPersistenceCookie testPcCookie = TestDataPersistenceController.getCookie((long)testId);
        boolean usesIPv4 = false;
        boolean usesIPv6 = false;
        for (Tag tag : testDataReference.getTags()) {
            if (tag.getName().equals("IPV4")) {
                usesIPv4 = true;
                continue;
            }
            if (!tag.getName().equals("IPV6")) continue;
            usesIPv6 = true;
        }
        ReportTemplateEntity reportTemplate = ReportTemplate_1_x.createReportTemplate_1_X(usesIPv4, usesIPv6);
        ReportGeneration reportGeneration = new ReportGeneration(testDataReference, new Date());
        this.persistReportGeneration(reportGeneration, this.metaDataPersistenceController);
        if (reportGeneration.getId() == null) {
            throw new IllegalStateException("ReportGeneration entity should have valid testId after persisting.");
        }
        PostProcessing postprocess = new PostProcessing();
        postprocess.run(testDataReference);
        Set formats = reportPreferences.getOutputFormats();
        boolean hasCSV = formats.contains(ReportOutputFormat.csv);
        boolean hasJson = formats.contains(ReportOutputFormat.json);
        formats.remove(ReportOutputFormat.csv);
        formats.remove(ReportOutputFormat.json);
        if ((formats.contains(ReportOutputFormat.html) || formats.contains(ReportOutputFormat.dynamicHtml)) && this.isLargeDatabase(testDataReference)) {
            formats.add(ReportOutputFormat.deprecatedjasperhtml);
        }
        if (formats.contains(ReportOutputFormat.deprecatedjasperhtml) || formats.contains(ReportOutputFormat.pdf)) {
            long startJasper = System.nanoTime();
            try {
                ReportManagerJasper reportManager = ReportManagerJasper.getInstance();
                reportManager.createReport(reportGeneration, reportTemplate, reportPreferences, (GenerateReportListener)this, monitor);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Deprecated reporting failed. Trying to continue with other reports." + e.getMessage());
            }
            LOGGER.info(String.format("Jasper took %f %n", (double)(System.nanoTime() - startJasper) / 1.0E9));
        }
        if (formats.contains(ReportOutputFormat.cloud)) {
            CloudUpload reportManager = new CloudUpload();
            reportManager.createReport(reportGeneration, reportTemplate, reportPreferences, reportGenerator, monitor);
        }
        if (formats.contains(ReportOutputFormat.dynamicHtml) && !this.isLargeDatabase(testDataReference)) {
            ReportManagerHtmlV2 reportManager = new ReportManagerHtmlV2(testDataReference);
            reportManager.createReport(reportGeneration, reportTemplate, reportPreferences, (GenerateReportListener)this, monitor);
        }
        if (formats.contains(ReportOutputFormat.html) && !this.isLargeDatabase(testDataReference)) {
            ReportManagerHtml reportManager = new ReportManagerHtml(testDataReference);
            reportManager.createReport(reportGeneration, reportTemplate, reportPreferences, (GenerateReportListener)this, monitor);
        }
        if (hasCSV) {
            formats.add(ReportOutputFormat.csv);
            ReportManagerPlainText csvReportManager = new ReportManagerPlainText();
            csvReportManager.createReport(reportGeneration, reportTemplate, reportPreferences, (GenerateReportListener)this, monitor);
        }
        if (hasJson) {
            formats.add(ReportOutputFormat.json);
            JsonReportManager jsonReportManager = new JsonReportManager();
            jsonReportManager.createReport(reportGeneration, reportTemplate, reportPreferences, (GenerateReportListener)this, monitor);
        }
        LOGGER.info("Finished generating reports.\n");
        testPcCookie.destroy();
    }

    private boolean isLargeDatabase(TestDataReference testDataReference) {
        long bytesize = testDataReference.getFileSize();
        return (double)bytesize > 1.0E7;
    }

    private void persistReportGeneration(ReportGeneration reportGeneration, MetaDataPersistenceController mdpc) {
        BaseEntityManager manager = new BaseEntityManager(ReportGeneration.class, mdpc);
        manager.persistIdEntity((BaseEntity)reportGeneration);
    }

    private TestDataReference getTestDataReference(Long testDataPersistenceId) {
        this.metaDataPersistenceController.forceInitialize();
        TestDataReferenceManager manager = new TestDataReferenceManager(this.metaDataPersistenceController);
        return (TestDataReference)manager.getEntity(testDataPersistenceId);
    }

    public void onReportFileLoaded() {
    }

    public void onReportCompiled() {
    }

    public void onReportFilled() {
    }

    public void onReportExported(ReportGeneration reportGeneration, String outputFile, ReportOutputFormat outputFormat) {
        this.persistReportInfo(reportGeneration, outputFile, outputFormat);
        for (ReportExportedListener listener : this.reportExportedListeners) {
            listener.onReportExported(outputFile, outputFormat);
        }
    }

    public void onReportFailed(ReportOutputFormat outputFormat, Exception e) {
    }

    private void persistReportInfo(ReportGeneration reportGeneration, String outputFile, ReportOutputFormat outputFormat) {
        ReportFileFormat format = this.getFileFormat(outputFormat.getExtension());
        Report report = new Report(reportGeneration, format, outputFile);
        reportGeneration.addReport(report);
        this.reportManager.persistIdEntity((BaseEntity)report);
    }

    private ReportFileFormat getFileFormat(String extension) {
        if (extension.equals("html")) {
            return ReportFileFormat.HTML;
        }
        if (extension.equals("pdf")) {
            return ReportFileFormat.PDF;
        }
        if (extension.equals("doc")) {
            return ReportFileFormat.DOC;
        }
        if (extension.equals("docx")) {
            return ReportFileFormat.DOCX;
        }
        if (extension.equals("xls")) {
            return ReportFileFormat.XLS;
        }
        if (extension.equals("xlsx")) {
            return ReportFileFormat.XLSX;
        }
        if (extension.equals("csv")) {
            return ReportFileFormat.CSV;
        }
        if (extension.equals("json")) {
            return ReportFileFormat.JSON;
        }
        System.out.println("ReportGenerator::getFileFormat : unknown extension : " + extension);
        return null;
    }
}

