/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.dataprovider.data.entities;

import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="report")
public class Report
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="report_generation_id", nullable=false)
    private ReportGeneration reportGeneration;
    @Enumerated(value=EnumType.STRING)
    @Column(name="file_format", length=40, nullable=false)
    private ReportFileFormat fileFormat;
    @Column(name="file_url", length=21844, nullable=false)
    private String fileUrl;
    @Transient
    private static List<PostPersistListener> postPersistListeners = new ArrayList<PostPersistListener>();

    public Report(ReportGeneration reportGeneration, ReportFileFormat fileFormat, String fileUrl) {
        if (reportGeneration == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'reportGeneration' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (fileFormat == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'reportFormat' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (fileUrl == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'reportUrl' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.reportGeneration = reportGeneration;
        this.reportGeneration.addReport(this);
        this.fileFormat = fileFormat;
        this.fileUrl = fileUrl;
    }

    Report() {
    }

    public ReportGeneration getReportGeneration() {
        return this.reportGeneration;
    }

    public ReportFileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public static void addPostPersistListener(PostPersistListener listener) {
        postPersistListeners.add(listener);
    }

    public static void removePostPersistListener(PostPersistListener listener) {
        postPersistListeners.remove(listener);
    }

    @PostPersist
    @PostUpdate
    public void postPersist() {
        for (PostPersistListener listener : postPersistListeners) {
            listener.postPersist(this);
        }
    }

    public static interface PostPersistListener {
        public void postPersist(Report var1);
    }
}

