
-- -----------------------------------------------------
-- Table `metadata_info`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `metadata_info` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `metadata_version` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `testdata_reference`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `testdata_reference` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `project_name` VARCHAR(21844) NULL,
  `project_author` VARCHAR(21844) NULL,
  `project_version` VARCHAR(40) NULL,
  `test_type` VARCHAR(40) NULL,
  `test_name` VARCHAR(21844) NULL,
  `testrun_title` VARCHAR(21844) NULL,
  `testrun_status` VARCHAR(40) NULL,
  `testrun_start_time` TIMESTAMP NULL,
  `testrun_end_time` TIMESTAMP NULL,
  `persistence_type` VARCHAR(40) NULL,
  `persistence_url` VARCHAR(21844) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `report_generation`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `report_generation` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `testdata_reference_id` BIGINT(20) NOT NULL,
  `generation_time` TIMESTAMP NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_report_generation_tdr` (`testdata_reference_id` ASC),
  CONSTRAINT `fk_report_generation_tdr`
    FOREIGN KEY (`testdata_reference_id`)
    REFERENCES `testdata_reference` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `report`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `report` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `report_generation_id` BIGINT(20) NOT NULL,
  `file_format` VARCHAR(40) NOT NULL,
  `file_url` VARCHAR(21844) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_report_reportgen` (`report_generation_id` ASC),
  CONSTRAINT `fk_report_reportgen`
    FOREIGN KEY (`report_generation_id`)
    REFERENCES `report_generation` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tag`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tag` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `testdata_reference_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_tag_testdata_reference1_idx` (`testdata_reference_id` ASC),
  UNIQUE INDEX `unique_index` (`name` ASC, `testdata_reference_id` ASC),
  CONSTRAINT `fk_tag_testdata_reference1`
    FOREIGN KEY (`testdata_reference_id`)
    REFERENCES `testdata_reference` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
