/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import java.util.Date;
import org.osgi.framework.Version;

class CanceledWirelessEndpoint
extends PostProcessor {
    private static String CANCEL_WE_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/131/33/canceling-scenarios-on-wireless-endpoints";
    private static final Version version = new Version(0, 0, 8);

    public CanceledWirelessEndpoint() {
        super("CanceledWirelessEndpoint", version);
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        EventManager evt = new EventManager(control);
        TestStatus end = reference.getStatus();
        if (TestStatus.CANCELLED.equals((Object)end) || TestStatus.ERROR.equals((Object)end) || TestStatus.EXECUTING.equals((Object)end)) {
            PortManager ports = new PortManager(control);
            for (Port p : ports.getEntities()) {
                PortStatus portStatus = p.getStatus();
                if (!p.isDockedMobile() || portStatus == PortStatus.STOPPED) continue;
                String format = "The port (%s) is docked on a mobile device. The device might need a manual cancel.";
                String suggestion = String.format(format, p.getName());
                PortEvent event = new PortEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, p);
                event.setKnowledgebaseLink(CANCEL_WE_ARTICLE);
                evt.persistIdEntity((BaseEntity)event);
            }
        }
    }
}

