/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Version;

class NatTimeoutSuggestion
extends PostProcessor {
    private static final String NAT_TIMEOUT_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/98/0/howto-testing-nat-device-with-byteblower";
    private static final Version version = new Version(0, 0, 1);
    private static final long EXPECTED_NAT_TIMEOUT = TimeUnit.MINUTES.toNanos(5L);

    public NatTimeoutSuggestion() {
        super("NatTimeoutSuggestion", version);
    }

    private boolean alreadyNat(Port port) {
        Layer3 layer3 = port.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            Layer3Ipv4 ipv4 = (Layer3Ipv4)layer3;
            return ipv4.getNatConfiguration() != null;
        }
        return false;
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List fbFlows = manager.getAllFrameBlasting(scenario);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            FbSource source = flowReader.getSource();
            if (source == null) continue;
            FbTrigger sourceTrigger = source.getTrigger();
            Port sourcePort = source.getPort();
            if (sourceTrigger == null) continue;
            long sourceBytes = sourceTrigger.getByteCount();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(control);
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                Port nattedPort;
                FbTrigger destinationTrigger = destination.getTrigger();
                if (destinationTrigger == null) continue;
                FbTriggerReader destinationTriggerReader = EntityReaderFactory.create((FbTrigger)destinationTrigger);
                if (sourceBytes <= 0L || destinationTriggerReader.getByteCount() != 0L) continue;
                Port destinationPort = destination.getPort();
                boolean eitherNatted = this.alreadyNat(destinationPort) || this.alreadyNat(sourcePort);
                boolean longWait = flowInstance.getStartTime() > EXPECTED_NAT_TIMEOUT;
                Port port = nattedPort = this.alreadyNat(destinationPort) ? destinationPort : sourcePort;
                if (!eitherNatted || !longWait) continue;
                EventManager evt = new EventManager(control);
                this.addSuggestion(nattedPort, flowReader, flowInstance.getStartTime(), evt);
            }
        }
    }

    private void addSuggestion(Port port, FbFlowInstanceReader flowreader, long actualStart, EventManager evt) {
        String format = "Port (%s) in flow (%s) is configured as NAT. Due to the late start (%s), the entry in the NAT-table might haven been erased.\nClick here for more information.";
        String suggestion = String.format(format, port.getName(), flowreader.getName(), HighResolutionCalendarParser.getRelativeTime((long)actualStart));
        PortEvent event = new PortEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, port);
        event.setKnowledgebaseLink(NAT_TIMEOUT_ARTICLE);
        evt.persistIdEntity((BaseEntity)event);
    }
}

