/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Version;

class SilentPortSuggesion
extends PostProcessor {
    private static final String FLOODING_WARNING_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/66/0/use-case-home-gateway-unitary-wan-ethernet-tests";
    private static final Version version = new Version(0, 0, 1);
    private static final long MAC_ADDRESS_TIMEOUT = TimeUnit.MINUTES.toNanos(5L);

    public SilentPortSuggesion() {
        super("SilentPortSuggestion", version);
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List fbFlows = manager.getAllFrameBlasting(scenario);
        List tcpFlows = manager.getAllTcp(scenario);
        HashSet<Port> withOutTraffic = new HashSet<Port>();
        HashSet<Port> knownPorts = new HashSet<Port>();
        for (HttpFlowInstance httpFlow : tcpFlows) {
            HttpFlowInstanceReader httpFlowReader;
            if (httpFlow.getDuration() == null || httpFlow.getClientHttpSession() == null || httpFlow.getRequestMethod() == null || (httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)httpFlow)).getSourceReader() == null || httpFlowReader.getDestinationReader() == null) continue;
            Port srcPort = (Port)httpFlowReader.getSourceReader().getEntity();
            Port dstPort = (Port)httpFlowReader.getDestinationReader().getEntity();
            withOutTraffic.add(srcPort);
            withOutTraffic.add(dstPort);
        }
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            FbSource source = flowReader.getSource();
            if (source == null) continue;
            FbTrigger sourceTrigger = source.getTrigger();
            Port sourcePort = source.getPort();
            if (sourceTrigger == null) continue;
            withOutTraffic.add(sourcePort);
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(control);
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbTrigger destinationTrigger = destination.getTrigger();
                if (destinationTrigger == null || flowInstance.getStartTime() + flowInstance.getDuration() <= MAC_ADDRESS_TIMEOUT) continue;
                knownPorts.add(destination.getPort());
            }
        }
        knownPorts.removeAll(withOutTraffic);
        EventManager evt = new EventManager(control);
        for (Port port : knownPorts) {
            PortEvent event = new PortEvent(new Date(), "No outgoing traffic, the entry in the ARP cache might be lost.\nClick here for more information.", EventSeverity.TEST_SUGGESTION, port);
            event.setKnowledgebaseLink(FLOODING_WARNING_ARTICLE);
            evt.persistIdEntity((BaseEntity)event);
        }
    }
}

