/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import java.util.List;

public class BaseEntityManager<T extends BaseEntity> {
    private final Class<T> type;
    protected final TestDataPersistenceController controller;

    public BaseEntityManager(Class<T> type, TestDataPersistenceController controller) {
        this.type = type;
        this.controller = controller;
    }

    public TestDataPersistenceController getPersistencyController() {
        return this.controller;
    }

    public T getEntity(Long id) throws TestDataPersistenceError {
        return this.controller.getEntity(this.type, id);
    }

    public List<T> getEntities() throws TestDataPersistenceError {
        return this.controller.getEntities(this.type);
    }

    public void persistIdEntity(T idEntity) throws TestDataPersistenceError {
        this.controller.persistIdEntity((BaseEntity)idEntity);
    }

    public void persistIdEntity(T[] idEntity) throws TestDataPersistenceError {
        this.controller.persistIdEntity((BaseEntity[])idEntity);
    }

    public void refreshIdEntity(T idEntity) throws TestDataPersistenceError {
        this.controller.refreshIdEntity((BaseEntity)idEntity);
    }

    public void lightInsert(T idEntity) throws TestDataPersistenceError {
        this.controller.lightInsert((BaseEntity)idEntity);
    }

    public void lightUpdate(T idEntity) throws TestDataPersistenceError {
        this.controller.lightUpdate((BaseEntity)idEntity);
    }
}

