/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance_;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

public class FlowInstanceManager
extends BaseEntityManager<FlowInstance> {
    public FlowInstanceManager(TestDataPersistenceController pc) {
        super(FlowInstance.class, pc);
    }

    public List<FlowInstance> getAll(Scenario scenario) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(FlowInstance.class);
        Root flowInstances = query.from(FlowInstance.class);
        query.where((Expression)qb.equal((Expression)flowInstances.get(FlowInstance_.scenario), (Object)scenario));
        query.orderBy(new Order[]{qb.asc((Expression)flowInstances.get(FlowInstance_.scenarioPosition))});
        return this.controller.getEntities(query);
    }

    public <FlowType extends FlowInstance> CriteriaQuery<FlowType> getAllFlowsOfTypeQuery(Scenario scenario, Class<FlowType> flowType) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(flowType);
        Root fbFlowInstances = query.from(flowType);
        query.where((Expression)qb.equal((Expression)fbFlowInstances.get(FlowInstance_.scenario), (Object)scenario));
        query.orderBy(new Order[]{qb.asc((Expression)fbFlowInstances.get(FlowInstance_.scenarioPosition))});
        return query;
    }

    public <FlowType extends FlowInstance> List<FlowType> getAllFlowsOfType(Scenario scenario, Class<FlowType> flowType) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(flowType);
        Root fbFlowInstances = query.from(flowType);
        Predicate predicate = qb.and((Expression)qb.equal((Expression)fbFlowInstances.get(FlowInstance_.scenario), (Object)scenario), (Expression)qb.or((Expression)qb.isNull((Expression)fbFlowInstances.get(FlowInstance_.parent)), (Expression)qb.lessThan((Expression)fbFlowInstances.get(FlowInstance_.parent), (Comparable)Long.valueOf(0L))));
        query.where((Expression)predicate);
        query.orderBy(new Order[]{qb.asc((Expression)fbFlowInstances.get(FlowInstance_.scenarioPosition))});
        return this.controller.getEntities(query);
    }

    public <FlowType extends FlowInstance> List<FlowType> getAllFlowsOfTypeIncludingParents(Scenario scenario, Class<FlowType> flowType) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(flowType);
        Root fbFlowInstances = query.from(flowType);
        query.where((Expression)qb.equal((Expression)fbFlowInstances.get(FlowInstance_.scenario), (Object)scenario));
        query.orderBy(new Order[]{qb.asc((Expression)fbFlowInstances.get(FlowInstance_.scenarioPosition))});
        return this.controller.getEntities(query);
    }

    public List<FbFlowInstance> getAllFrameBlasting(Scenario scenario) throws TestDataPersistenceError {
        return this.getAllFlowsOfType(scenario, FbFlowInstance.class);
    }

    public List<HttpFlowInstance> getAllTcp(Scenario scenario) throws TestDataPersistenceError {
        return this.getAllFlowsOfType(scenario, HttpFlowInstance.class);
    }

    public List<FbDestination> getAllFbDestinations(Scenario scenario) throws TestDataPersistenceError {
        ArrayList<FbDestination> list = new ArrayList<FbDestination>();
        List<FbFlowInstance> fbFlows = this.getAllFrameBlasting(scenario);
        for (FbFlowInstance fbFlowInstance : fbFlows) {
            FbFlowInstanceManager manager = new FbFlowInstanceManager(this.getPersistencyController());
            list.addAll(manager.getFbDestinationsAndEavesdroppers(fbFlowInstance));
        }
        return list;
    }

    public FlowInstance find(Scenario scenario, Integer position) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(FlowInstance.class);
        Root flowInstances = query.from(FlowInstance.class);
        query.where((Expression)qb.and((Expression)qb.equal((Expression)flowInstances.get(FlowInstance_.scenario), (Object)scenario), (Expression)qb.equal((Expression)flowInstances.get(FlowInstance_.scenarioPosition), (Object)position)));
        return (FlowInstance)this.controller.getEntity(query);
    }
}

