/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address_;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;

public class Ipv6AddressManager
extends BaseEntityManager<Ipv6Address> {
    public Ipv6AddressManager(TestDataPersistenceController pc) {
        super(Ipv6Address.class, pc);
    }

    public Ipv6Address findOrCreate(String ipv6AddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.findOrCreate(Ipv6AddressUtility.convertToBinary(ipv6AddressString));
    }

    public Ipv6Address findOrCreate(byte[] ipv6Binary) throws TestDataPersistenceError {
        Ipv6Address dbEntity = this.find(ipv6Binary);
        if (dbEntity == null) {
            dbEntity = new Ipv6Address(ipv6Binary);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public Ipv6Address find(String ipv6AddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.find(Ipv6AddressUtility.convertToBinary(ipv6AddressString));
    }

    public Ipv6Address find(byte[] ipv6Binary) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Ipv6Address.class);
        Root addresses = query.from(Ipv6Address.class);
        query.where((Expression)qb.equal((Expression)addresses.get(Ipv6Address_.address), (Object)ipv6Binary));
        return (Ipv6Address)this.controller.getEntity(query);
    }
}

