/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping_;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;

public class NatAddressMappingManager
extends BaseEntityManager<NatAddressMapping> {
    public NatAddressMappingManager(TestDataPersistenceController pc) {
        super(NatAddressMapping.class, pc);
    }

    public NatAddressMapping createOrUpdate(Scenario scenario, Port resolverPort, Port targetPort, Ipv4Address publicAddress, String method) throws TestDataPersistenceError {
        NatAddressMapping dbEntity = this.find(scenario, resolverPort, targetPort);
        if (dbEntity == null) {
            dbEntity = new NatAddressMapping(scenario, resolverPort, targetPort, publicAddress, method);
            this.persistIdEntity(dbEntity);
        } else {
            dbEntity.setPublicAddress(publicAddress);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public NatAddressMapping find(Scenario scenario, Port resolverPort, Port targetPort) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(NatAddressMapping.class);
        Root addressMappings = query.from(NatAddressMapping.class);
        query.where((Expression)qb.and(new Predicate[]{qb.equal((Expression)addressMappings.get(NatAddressMapping_.scenario), (Object)scenario), qb.equal((Expression)addressMappings.get(NatAddressMapping_.resolverPort), (Object)resolverPort), qb.equal((Expression)addressMappings.get(NatAddressMapping_.targetPort), (Object)targetPort)}));
        return (NatAddressMapping)this.controller.getEntity(query);
    }

    public List<NatAddressMapping> find(Scenario scenario, Port targetPort) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(NatAddressMapping.class);
        Root addressMappings = query.from(NatAddressMapping.class);
        query.where((Expression)qb.and((Expression)qb.equal((Expression)addressMappings.get(NatAddressMapping_.scenario), (Object)scenario), (Expression)qb.equal((Expression)addressMappings.get(NatAddressMapping_.targetPort), (Object)targetPort)));
        return this.controller.getEntities(query);
    }
}

