/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type")
@DiscriminatorValue(value="GENERIC")
@Table(name="event")
public class Event
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="event_time", nullable=false)
    private Date eventTime;
    @Enumerated(value=EnumType.STRING)
    @Column(name="severity", length=40, nullable=false)
    private EventSeverity severity;
    @Column(name="description", length=21844, nullable=false)
    private String description;
    @Column(name="suggestion", length=21844, nullable=false)
    private String suggestion;
    @Column(name="knowledgebase_link", length=1024, nullable=false)
    private String knowledgebaseLink;

    public Event(Date eventTime, String description, EventSeverity severity, String suggestion, String knowledgeBaseLink) {
        if (eventTime == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'eventTime' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (description == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'description' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (severity == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'severity' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.eventTime = eventTime;
        this.description = description;
        this.severity = severity;
        this.suggestion = suggestion;
        this.knowledgebaseLink = knowledgeBaseLink;
    }

    public Event(Date eventTime, String description, EventSeverity severity) {
        this(eventTime, description, severity, "", "");
    }

    Event() {
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public EventSeverity getSeverity() {
        return this.severity;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public String getKnowledgebaseLink() {
        if (this.knowledgebaseLink == null) {
            return "";
        }
        return this.knowledgebaseLink;
    }

    public void setKnowledgebaseLink(String kbLink) {
        this.knowledgebaseLink = kbLink;
    }
}

