/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSizeDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.interfaces.IFbResult;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Entity
@Table(name="fb_trigger")
public class FbTrigger
extends BaseEntity
implements IFbResult<FbTriggerSnapshot> {
    private static final long serialVersionUID = 2L;
    @Column(name="first_packet_time")
    private Long firstPacketTime = null;
    @Column(name="last_packet_time")
    private Long lastPacketTime = null;
    @Column(name="packet_count", nullable=false)
    private long packetCount = 0L;
    @Column(name="byte_count", nullable=false)
    private long byteCount = 0L;
    @Column(name="snapshot_resolution")
    private Long snapshotResolution;
    @OneToMany(mappedBy="trigger")
    private List<FbTriggerSnapshot> snapshots = new ArrayList<FbTriggerSnapshot>();
    @OneToOne(mappedBy="trigger")
    private FbTriggerSizeDistribution distribution = null;
    @Transient
    private FbTriggerSnapshot latestSnapshot;

    public Long getFirstPacketTime() {
        return this.firstPacketTime;
    }

    public void setFirstPacketTime(Long firstPacketTime) {
        this.firstPacketTime = firstPacketTime;
    }

    public Long getLastPacketTime() {
        return this.lastPacketTime;
    }

    public void setLastPacketTime(Long lastPacketTime) {
        this.lastPacketTime = lastPacketTime;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public void setPacketCount(long packetCount) {
        this.packetCount = packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public Long getSnapshotResolution() {
        return this.snapshotResolution;
    }

    public void setSnapshotResolution(long snapshotResolution) {
        this.snapshotResolution = snapshotResolution;
    }

    @Override
    public List<FbTriggerSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    void addSnapshot(FbTriggerSnapshot snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding entity property 'snapshot' of type " + this.getClass().getSimpleName());
        }
        this.snapshots.add(snapshot);
    }

    public FbTriggerSizeDistribution getDistribution() {
        return this.distribution;
    }

    void setDistribution(FbTriggerSizeDistribution distribution) {
        if (this.distribution != null) {
            throw new IllegalStateException("Cannot modify entity property 'distribution' once it has been set");
        }
        if (distribution == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'distribution' of type " + this.getClass().getSimpleName());
        }
        this.distribution = distribution;
    }

    public void setLatestSnapshot(FbTriggerSnapshot snapshot) {
        this.latestSnapshot = snapshot;
    }

    @Override
    public FbTriggerSnapshot getLatestSnapshot() {
        return this.latestSnapshot;
    }
}

