/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Application;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpApplicationType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;

@Entity
@DiscriminatorValue(value="HTTP")
@Table(name="http_application")
public class HttpApplication
extends Application {
    private static final long serialVersionUID = 1L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type_http", length=40, nullable=false)
    private HttpApplicationType applicationType;
    @Column(name="port_number", nullable=false)
    private Integer portNumber;
    @OneToMany(mappedBy="httpApplication")
    private List<HttpSession> httpSessions;

    public HttpApplication(Scenario scenario, Port port, HttpApplicationType applicationType, Integer portNumber) {
        super(scenario, port);
        if (applicationType == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'applicationType' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (portNumber == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'portNumber' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.applicationType = applicationType;
        this.portNumber = portNumber;
        this.httpSessions = new ArrayList<HttpSession>();
    }

    HttpApplication() {
    }

    public HttpApplicationType getApplicationType() {
        return this.applicationType;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public List<HttpSession> getHttpSessions() {
        return this.httpSessions;
    }

    void addHttpSession(HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding entity property 'httpSession' of type " + this.getClass().getSimpleName());
        }
        this.httpSessions.add(httpSession);
    }
}

