/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestStatus;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;

@Entity
@DiscriminatorValue(value="HTTP")
@Table(name="http_flow_instance")
public class HttpFlowInstance
extends FlowInstance {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="http_flow_template_id", nullable=false)
    private HttpFlowTemplate flowTemplate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="request_method")
    private HttpRequestMethod requestMethod;
    @Enumerated(value=EnumType.STRING)
    @Column(name="request_status")
    private HttpRequestStatus requestStatus;
    @OneToOne
    @JoinColumn(name="client_http_session_id", unique=true)
    private HttpSession clientHttpSession;
    @OneToOne
    @JoinColumn(name="server_http_session_id", unique=true)
    private HttpSession serverHttpSession;
    @Column(name="restarts")
    private int restarts;

    public HttpFlowInstance(Scenario scenario, Flow flow, Integer scenarioPosition, Long startTime, Long duration, String tos, HttpFlowTemplate flowTemplate) {
        super(scenario, flow, scenarioPosition, startTime, duration, tos);
        if (flowTemplate == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'flowTemplate' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.flowTemplate = flowTemplate;
    }

    HttpFlowInstance() {
    }

    public HttpFlowTemplate getFlowTemplate() {
        return this.flowTemplate;
    }

    public HttpRequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(HttpRequestMethod requestMethod) {
        if (this.requestMethod != null) {
            throw new IllegalStateException("Cannot modify entity property 'requestMethod' once it has been set");
        }
        if (requestMethod == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'requestMethod' of type " + this.getClass().getSimpleName());
        }
        this.requestMethod = requestMethod;
    }

    public HttpRequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(HttpRequestStatus requestStatus) {
        if (requestStatus == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'requestStatus' of type " + this.getClass().getSimpleName());
        }
        this.requestStatus = requestStatus;
    }

    public HttpSession getClientHttpSession() {
        return this.clientHttpSession;
    }

    public void setClientHttpSession(HttpSession clientHttpSession) {
        if (this.clientHttpSession != null) {
            throw new IllegalStateException("Cannot modify entity property 'clientHttpSession' once it has been set");
        }
        if (clientHttpSession == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'clientHttpSession' of type " + this.getClass().getSimpleName());
        }
        this.clientHttpSession = clientHttpSession;
    }

    public HttpSession getServerHttpSession() {
        return this.serverHttpSession;
    }

    public void setServerHttpSession(HttpSession serverHttpSession) {
        if (this.serverHttpSession != null) {
            throw new IllegalStateException("Cannot modify entity property 'serverHttpSession' once it has been set");
        }
        if (serverHttpSession == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'serverHttpSession' of type " + this.getClass().getSimpleName());
        }
        this.serverHttpSession = serverHttpSession;
    }

    public void addRestarts(int count) {
        this.restarts += count;
    }

    public final int getRestarts() {
        return this.restarts;
    }

    public final String getRequestStatusString() {
        HttpRequestStatus status = this.getRequestStatus();
        if (status == null) {
            return null;
        }
        int nofRestarts = this.getRestarts();
        if (nofRestarts == 0) {
            return status.toString();
        }
        String fmt = "RESTARTED (%d time%s)";
        return String.format(fmt, nofRestarts, nofRestarts > 1 ? "s" : "");
    }
}

