/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethodConfig;
import com.excentis.products.byteblower.results.testdata.data.enums.TcpCongestionAvoidanceAlgorithm;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;

@Entity
@Table(name="http_flow_template")
public class HttpFlowTemplate
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=21844, unique=true, nullable=false)
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="http_request_method", nullable=false)
    private HttpRequestMethodConfig requestMethod;
    @Column(name="http_data_size")
    private Long httpDataSize;
    @Column(name="rate_limitation")
    private Long rateLimitation;
    @Column(name="client_port")
    private Integer clientPort;
    @Column(name="server_port")
    private Integer serverPort;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ca_algorithm", nullable=false)
    private TcpCongestionAvoidanceAlgorithm congestionAvoidanceAlgorithm;
    @Column(name="rx_window_initial_unscaled_size", nullable=false)
    private Integer rxWindowInitialUnscaledSize;
    @Column(name="rx_window_scale_value")
    private Integer rxWindowScaleValue;
    @Column(name="is_l4s_enabled")
    private Boolean isL4sEnabled;

    public HttpFlowTemplate(String name, HttpRequestMethodConfig requestMethod, Long httpDataSize, Long rateLimitation, Integer clientPort, Integer serverPort, TcpCongestionAvoidanceAlgorithm congestionAvoidanceAlgorithm, Integer rxWindowInitialUnscaledSize, Integer rxWindowScaleValue, boolean isL4sEnabled) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (requestMethod == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'requestMethod' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (congestionAvoidanceAlgorithm == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'congestionAvoidanceAlgorithm' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (rxWindowInitialUnscaledSize == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'rxWindowInitialUnscaledSize' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.requestMethod = requestMethod;
        this.httpDataSize = httpDataSize;
        this.rateLimitation = rateLimitation;
        this.clientPort = clientPort;
        this.serverPort = serverPort;
        this.congestionAvoidanceAlgorithm = congestionAvoidanceAlgorithm;
        this.rxWindowInitialUnscaledSize = rxWindowInitialUnscaledSize;
        this.rxWindowScaleValue = rxWindowScaleValue;
        this.isL4sEnabled = isL4sEnabled;
    }

    HttpFlowTemplate() {
    }

    public String getName() {
        return this.name;
    }

    public HttpRequestMethodConfig getRequestMethod() {
        return this.requestMethod;
    }

    public Long getHttpDataSize() {
        return this.httpDataSize;
    }

    public Long getRateLimitation() {
        return this.rateLimitation;
    }

    public Integer getClientPort() {
        return this.clientPort;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public TcpCongestionAvoidanceAlgorithm getCongestionAvoidanceAlgorithm() {
        return this.congestionAvoidanceAlgorithm;
    }

    public Integer getRxWindowInitialUnscaledSize() {
        return this.rxWindowInitialUnscaledSize;
    }

    public Integer getRxWindowScaleValue() {
        return this.rxWindowScaleValue;
    }

    public Boolean getIsL4sEnabled() {
        return this.isL4sEnabled;
    }
}

