/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.HttpApplication;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Entity
@Table(name="http_session")
public class HttpSession
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="application_http_id", nullable=false)
    private HttpApplication httpApplication;
    @OneToOne
    @JoinColumn(name="tcp_session_id", unique=true, nullable=false)
    private TcpSession tcpSession;
    @Column(name="tx_first_byte_time")
    private Long txFirstByteTime;
    @Column(name="tx_last_byte_time")
    private Long txLastByteTime;
    @Column(name="rx_first_byte_time")
    private Long rxFirstByteTime;
    @Column(name="rx_last_byte_time")
    private Long rxLastByteTime;
    @Column(name="tx_byte_count")
    private Long txByteCount;
    @Column(name="tx_header_byte_count")
    private Long txHeaderByteCount;
    @Column(name="tx_payload_byte_count")
    private Long txPayloadByteCount;
    @Column(name="rx_byte_count")
    private Long rxByteCount;
    @Column(name="rx_header_byte_count")
    private Long rxHeaderByteCount;
    @Column(name="rx_payload_byte_count")
    private Long rxPayloadByteCount;
    @Column(name="snapshot_resolution")
    private Long snapshotResolution;
    @OneToMany(mappedBy="httpSession", cascade={CascadeType.ALL})
    private List<HttpSessionSnapshot> snapshots;
    @Transient
    private HttpSessionSnapshot latestSnapshot;

    public HttpSession(HttpApplication httpApplication, TcpSession tcpSession) {
        if (httpApplication == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'httpApplication' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (tcpSession == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'tcpSession' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.httpApplication = httpApplication;
        this.httpApplication.addHttpSession(this);
        this.tcpSession = tcpSession;
        this.snapshots = new ArrayList<HttpSessionSnapshot>();
    }

    HttpSession() {
    }

    public HttpApplication getHttpApplication() {
        return this.httpApplication;
    }

    public TcpSession getTcpSession() {
        return this.tcpSession;
    }

    public Long getTxFirstByteTime() {
        return this.txFirstByteTime;
    }

    public void setTxFirstByteTime(Long txFirstByteTime) {
        this.txFirstByteTime = txFirstByteTime;
    }

    public Long getTxLastByteTime() {
        return this.txLastByteTime;
    }

    public void setTxLastByteTime(Long txLastByteTime) {
        this.txLastByteTime = txLastByteTime;
    }

    public Long getRxFirstByteTime() {
        return this.rxFirstByteTime;
    }

    public void setRxFirstByteTime(Long rxFirstByteTime) {
        this.rxFirstByteTime = rxFirstByteTime;
    }

    public Long getRxLastByteTime() {
        return this.rxLastByteTime;
    }

    public void setRxLastByteTime(Long rxLastByteTime) {
        this.rxLastByteTime = rxLastByteTime;
    }

    public Long getTxByteCount() {
        return this.txByteCount;
    }

    public void setTxByteCount(Long txByteCount) {
        this.txByteCount = txByteCount;
    }

    public Long getRxByteCount() {
        return this.rxByteCount;
    }

    public void setRxByteCount(Long rxByteCount) {
        this.rxByteCount = rxByteCount;
    }

    public Long getSnapshotResolution() {
        return this.snapshotResolution;
    }

    public void setSnapshotResolution(Long snapshotResolution) {
        this.snapshotResolution = snapshotResolution;
    }

    public List<HttpSessionSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    void addSnapshot(HttpSessionSnapshot snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding snapshot to entity property 'snapshots' of type " + this.getClass().getSimpleName());
        }
        this.snapshots.add(snapshot);
    }

    public void setLatestSnapshot(HttpSessionSnapshot snapshot) {
        this.latestSnapshot = snapshot;
    }

    public HttpSessionSnapshot getLatestSnapshot() {
        return this.latestSnapshot;
    }

    public void setRxByteCountHeader(long rxByteCountHeader) {
        this.rxHeaderByteCount = rxByteCountHeader;
    }

    public void setRxBytePayload(long rxByteCountPayload) {
        this.rxPayloadByteCount = rxByteCountPayload;
    }

    public void setTxByteCountHeader(long txByteCountHeader) {
        this.txHeaderByteCount = txByteCountHeader;
    }

    public void setTxByteCountPayload(long txByteCountPayload) {
        this.txPayloadByteCount = txByteCountPayload;
    }

    public boolean isDockedMobile() {
        return this.getHttpApplication().getPort().isDockedMobile();
    }
}

