/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Arrays;

@Entity
@Table(name="ipv4_address")
public class Ipv4Address
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    private static Ipv4Address INVALID_ADDRESS = new Ipv4Address(new byte[4]);
    @Column(name="address", length=4, unique=true, nullable=false)
    private byte[] address;

    public Ipv4Address(byte[] address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'address' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.address = address;
    }

    Ipv4Address() {
    }

    public byte[] getAddress() {
        return this.address;
    }

    public boolean isValid() {
        return !Arrays.equals(this.address, Ipv4Address.INVALID_ADDRESS.address);
    }
}

