/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionGateway;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionPrefix;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="layer3_ipv6_session")
public class Layer3Ipv6Session
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToOne
    @JoinColumn(name="layer3_ipv6_id", unique=true, nullable=false)
    private Layer3Ipv6 configuration;
    @ManyToOne
    @JoinColumn(name="linklocal_address_id", nullable=false)
    private Ipv6Address linkLocalAddress;
    @OneToMany(mappedBy="session")
    private Set<Layer3Ipv6SessionPrefix> prefixes;
    @OneToMany(mappedBy="session")
    private Set<Layer3Ipv6SessionGateway> gatewayAddresses;

    public Layer3Ipv6Session(Layer3Ipv6 configuration, Ipv6Address linkLocalAddress) {
        if (configuration == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'configuration' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (linkLocalAddress == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'linkLocalAddress' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.configuration = configuration;
        this.configuration.setSession(this);
        this.linkLocalAddress = linkLocalAddress;
        this.prefixes = new HashSet<Layer3Ipv6SessionPrefix>();
        this.gatewayAddresses = new HashSet<Layer3Ipv6SessionGateway>();
    }

    Layer3Ipv6Session() {
    }

    public Layer3Ipv6 getConfiguration() {
        return this.configuration;
    }

    public Ipv6Address getLinkLocalAddress() {
        return this.linkLocalAddress;
    }

    public Set<Layer3Ipv6SessionPrefix> getPrefixes() {
        return Collections.unmodifiableSet(this.prefixes);
    }

    void addPrefix(Layer3Ipv6SessionPrefix prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding prefix to entity property 'prefixes' of type " + this.getClass().getSimpleName());
        }
        if (!this.prefixes.contains(prefix)) {
            this.prefixes.add(prefix);
        }
    }

    public Set<Layer3Ipv6SessionGateway> getGatewayAddresses() {
        return Collections.unmodifiableSet(this.gatewayAddresses);
    }

    void addGatewayAddress(Layer3Ipv6SessionGateway gatewayAddress) {
        if (gatewayAddress == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding gateway address to entity property 'gatewayAddresses' of type " + this.getClass().getSimpleName());
        }
        if (!this.gatewayAddresses.contains(gatewayAddress)) {
            this.gatewayAddresses.add(gatewayAddress);
        }
    }
}

