/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.MulticastSource;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="multicast_sourcegroup")
public class MulticastSourceGroup
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=21844, nullable=false)
    private String name;
    @OneToMany(mappedBy="sourceGroup")
    private Set<MulticastSource> sources;

    public MulticastSourceGroup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.sources = new HashSet<MulticastSource>();
    }

    MulticastSourceGroup() {
    }

    public String getName() {
        return this.name;
    }

    public Set<MulticastSource> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    void addSource(MulticastSource multicastSource) {
        if (multicastSource == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding multicast source to entity property 'sources' of type " + this.getClass().getSimpleName());
        }
        if (!this.sources.contains(multicastSource)) {
            this.sources.add(multicastSource);
        }
    }
}

