/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="scenario")
public class Scenario
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=21844, unique=true, nullable=false)
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=40, nullable=false)
    private ScenarioStatus status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="init_start_time")
    private Date initStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="init_end_time")
    private Date initEndTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="run_start_time")
    private Date runStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="run_end_time")
    private Date runEndTime;
    @OneToMany(mappedBy="scenario")
    private List<FlowInstance> flowInstances;

    public Scenario(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.status = ScenarioStatus.CREATED;
        this.initStartTime = null;
        this.initEndTime = null;
        this.runStartTime = null;
        this.runEndTime = null;
        this.flowInstances = new ArrayList<FlowInstance>();
    }

    Scenario() {
    }

    public String getName() {
        return this.name;
    }

    public ScenarioStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScenarioStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'status' of type " + this.getClass().getSimpleName());
        }
        this.status = status;
    }

    public Date getInitStartTime() {
        return this.initStartTime;
    }

    public void setInitStartTime(Date initStartTime) {
        if (this.initStartTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'initStartTime' once it has been set");
        }
        if (initStartTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'initStartTime' of type " + this.getClass().getSimpleName());
        }
        this.initStartTime = initStartTime;
    }

    public Date getInitEndTime() {
        return this.initEndTime;
    }

    public void setInitEndTime(Date initEndTime) {
        if (this.initEndTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'initEndTime' once it has been set");
        }
        if (initEndTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'initEndTime' of type " + this.getClass().getSimpleName());
        }
        this.initEndTime = initEndTime;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public void setRunStartTime(Date runStartTime) {
        if (this.runStartTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'runStartTime' once it has been set");
        }
        if (runStartTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'runStartTime' of type " + this.getClass().getSimpleName());
        }
        this.runStartTime = runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public void setRunEndTime(Date runEndTime) {
        if (runEndTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'runEndTime' of type " + this.getClass().getSimpleName());
        }
        this.runEndTime = runEndTime;
    }

    public List<FlowInstance> getFlowInstances() {
        return Collections.unmodifiableList(this.flowInstances);
    }

    void addFlowInstance(FlowInstance flowInstance) {
        if (flowInstance == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'flowInstance' of type " + this.getClass().getSimpleName());
        }
        if (!this.flowInstances.contains(flowInstance)) {
            this.flowInstances.add(flowInstance);
        }
    }
}

