/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowResult;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;

@Entity
@Table(name="throughput_flow_test")
public class ThroughputFlowTest
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=1024, unique=true, nullable=false)
    private String name;
    @ManyToOne
    @JoinColumn(name="source_id", nullable=false)
    private Port source;
    @ManyToOne
    @JoinColumn(name="destination_id", nullable=false)
    private Port destination;
    @ManyToOne
    @JoinColumn(name="fb_flow_template_id", nullable=false)
    private FbFlowTemplate flowTemplate;
    @OneToMany(mappedBy="test", cascade={CascadeType.ALL})
    private List<ThroughputFlowResult> snapshots;
    @Column(name="iteration_size", nullable=false)
    private long iterationSize;
    @Column(name="acceptable_loss", nullable=false)
    private double acceptableLoss;
    @Column(name="resolution", nullable=false)
    private double resolution;

    protected ThroughputFlowTest() {
        this.iterationSize = 0L;
        this.name = "";
        this.snapshots = new ArrayList<ThroughputFlowResult>();
    }

    public ThroughputFlowTest(Port src, Port dest, FbFlowTemplate template, long iterationSize, String name, double allowedLoss, double resolution) {
        this.source = src;
        this.destination = dest;
        this.flowTemplate = template;
        this.iterationSize = iterationSize;
        this.name = name;
        this.snapshots = new ArrayList<ThroughputFlowResult>();
        this.acceptableLoss = allowedLoss;
        this.resolution = resolution;
    }

    public long getIterationSize() {
        return this.iterationSize;
    }

    public SortedSet<ThroughputFlowResult> getResults() {
        return new TreeSet<ThroughputFlowResult>(this.snapshots);
    }

    public FbFlowTemplate getFlowTemplate() {
        return this.flowTemplate;
    }

    public Port getSource() {
        return this.source;
    }

    public Port getDestination() {
        return this.destination;
    }

    public void addResult(ThroughputFlowResult result) {
        this.snapshots.add(result);
    }

    public void mergeResult(ThroughputFlowResult result) {
        ListIterator<ThroughputFlowResult> it = this.snapshots.listIterator();
        HashSet<Long> intervals = new HashSet<Long>();
        while (it.hasNext()) {
            ThroughputFlowResult snap = it.next();
            intervals.add(snap.getFrameInterval());
            if (snap.getFrameInterval() != result.getFrameInterval()) continue;
            return;
        }
        System.out.println("Storing frame interval " + result.getFrameInterval() + " " + ((Object)intervals).toString());
        this.snapshots.add(result);
    }

    public double getAcceptableLoss() {
        return this.acceptableLoss;
    }

    public double getResolution() {
        return this.resolution;
    }

    public String getName() {
        return this.name;
    }
}

