/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFbResultReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencySnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

public class FbLatencyReader
extends AbstractFbResultReader<FbLatency, FbLatencySnapshot> {
    FbLatencyReader(FbLatency entity) {
        super(entity);
    }

    public List<FbLatencySnapshotReader> getSnapshotReaders() {
        ArrayList<FbLatencySnapshotReader> snapshotReaders = new ArrayList<FbLatencySnapshotReader>();
        for (FbLatencySnapshot snapshot : ((FbLatency)this.entity).getSnapshots()) {
            snapshotReaders.add(EntityReaderFactory.create(snapshot));
        }
        return snapshotReaders;
    }

    public FbLatencySnapshotReader getLatestSnapshotReader() {
        FbLatencySnapshot latestSnapshot = (FbLatencySnapshot)this.getLatestSnapshot();
        if (latestSnapshot == null) {
            return null;
        }
        return EntityReaderFactory.create((FbLatencySnapshot)this.getLatestSnapshot());
    }

    public Double getLatencyMinimum(LatencyUnit unit) {
        return LatencyUnit.convert(((FbLatency)this.entity).getLatencyMinimum(), LatencyUnit.NANOSECONDS, unit);
    }

    public Double getLatencyMaximum(LatencyUnit unit) {
        return LatencyUnit.convert(((FbLatency)this.entity).getLatencyMaximum(), LatencyUnit.NANOSECONDS, unit);
    }

    public Double getLatencyAverage(LatencyUnit unit) {
        return LatencyUnit.convert(((FbLatency)this.entity).getLatencyAverage(), LatencyUnit.NANOSECONDS, unit);
    }

    public Double getJitter(LatencyUnit unit) {
        return LatencyUnit.convert(((FbLatency)this.entity).getJitter(), LatencyUnit.NANOSECONDS, unit);
    }

    public TypedQuery<FbLatencySnapshot> getSnapshotsQuery(EntityManager entityManager) {
        return this.getSnapshotsQuery(entityManager, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public TypedQuery<FbLatencySnapshot> getSnapshotsQuery(EntityManager entityManager, long start, long end) {
        TypedQuery query = entityManager.createQuery("SELECT t FROM FbLatencySnapshot t  WHERE t.latency = :latency AND :start <= t.snapshotTime AND t.snapshotTime < :end  ORDER BY t.snapshotTime ASC", FbLatencySnapshot.class);
        query = query.setParameter("latency", (Object)this.entity);
        query = query.setParameter("start", (Object)start);
        query = query.setParameter("end", (Object)end);
        return query;
    }
}

