/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFbResultReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.ResultsOverTimeUtility;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class FbOutOfSequenceReader
extends AbstractFbResultReader<FbOutOfSequence, FbOutOfSequenceSnapshot> {
    FbOutOfSequenceReader(FbOutOfSequence entity) {
        super(entity);
    }

    public List<FbOutOfSequenceSnapshotReader> getSnapshotReaders() {
        ArrayList<FbOutOfSequenceSnapshotReader> snapshotReaders = new ArrayList<FbOutOfSequenceSnapshotReader>();
        for (FbOutOfSequenceSnapshot snapshot : ((FbOutOfSequence)this.entity).getSnapshots()) {
            snapshotReaders.add(EntityReaderFactory.create(snapshot));
        }
        return snapshotReaders;
    }

    public Long getPacketCountOutOfSequence() {
        if (this.entity == null) {
            return null;
        }
        return ((FbOutOfSequence)this.entity).getPacketCountOutOfSequence();
    }

    public FbOutOfSequenceSnapshotReader getLatestSnapshotReader() {
        FbOutOfSequenceSnapshot latestSnapshot = (FbOutOfSequenceSnapshot)this.getLatestSnapshot();
        if (latestSnapshot == null) {
            return null;
        }
        return EntityReaderFactory.create((FbOutOfSequenceSnapshot)this.getLatestSnapshot());
    }

    public SortedMap<Date, Double> getOutOfSequenceOverTime(ResultsOverTimeUtility.BucketChartType chartType) {
        if (this.getSnapshotReaders().isEmpty()) {
            return new TreeMap<Date, Double>();
        }
        ArrayList<ResultsOverTimeUtility.BucketDataPoint> dataPoints = new ArrayList<ResultsOverTimeUtility.BucketDataPoint>();
        for (FbOutOfSequenceSnapshotReader snapshotReader : this.getSnapshotReaders()) {
            dataPoints.add(new ResultsOverTimeUtility.BucketDataPoint(snapshotReader.getOutOfSequenceFrameRate(), snapshotReader.getSnapshotTimeNs(), snapshotReader.getSnapshotDurationNs()));
        }
        return ResultsOverTimeUtility.getChartValuePointsDate(chartType, ((FbOutOfSequence)this.entity).getSnapshotResolution(), dataPoints, false, false);
    }

    public TypedQuery<FbOutOfSequenceSnapshot> getSnapshotsQuery(EntityManager entityManager) {
        return this.getSnapshotsQuery(entityManager, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public TypedQuery<FbOutOfSequenceSnapshot> getSnapshotsQuery(EntityManager entityManager, long start, long end) {
        TypedQuery query = entityManager.createQuery("SELECT t FROM FbOutOfSequenceSnapshot t  WHERE t.outOfSequence = :outOfSequence AND :start <= t.snapshotTime AND t.snapshotTime < :end ORDER BY t.snapshotTime ASC", FbOutOfSequenceSnapshot.class);
        query = query.setParameter("outOfSequence", (Object)this.entity);
        query = query.setParameter("start", (Object)start);
        query = query.setParameter("end", (Object)end);
        return query;
    }
}

