/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFbResultReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;

public class FbTriggerReader
extends AbstractFbResultReader<FbTrigger, FbTriggerSnapshot> {
    FbTriggerReader(FbTrigger entity) {
        super(entity);
    }

    public TypedQuery<FbTriggerSnapshot> getSnapshotsQuery(EntityManager entityManager, long start, long end) {
        TypedQuery query = entityManager.createQuery("SELECT t FROM FbTriggerSnapshot t WHERE t.trigger = :trigger AND t.snapshotTime >= :start AND t.snapshotTime < :end ORDER BY t.snapshotTime ASC", FbTriggerSnapshot.class);
        query = query.setParameter("trigger", (Object)this.entity);
        query = query.setParameter("start", (Object)start);
        query = query.setParameter("end", (Object)end);
        return query;
    }

    public TypedQuery<FbTriggerSnapshot> getSnapshotsQuery(EntityManager entityManager) {
        return this.getSnapshotsQuery(entityManager, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public FbTriggerSnapshotReader getLatestSnapshotReader() {
        FbTriggerSnapshot latestSnapshot = (FbTriggerSnapshot)this.getLatestSnapshot();
        if (latestSnapshot == null) {
            return null;
        }
        return EntityReaderFactory.create(latestSnapshot);
    }

    public Double getThroughput(EthernetThroughputType throughputType, DataRateUnit dataRateUnit) {
        Double throughputBps = this.getThroughputBitsPerSecond(throughputType);
        return ThroughputReader.convertThroughput(throughputBps, DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getThroughputBitsPerSecond(EthernetThroughputType throughputType) {
        if (((FbTrigger)this.entity).getFirstPacketTime() == null) {
            return 0.0;
        }
        Double durationSeconds = this.getDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        Long byteCount = ((FbTrigger)this.entity).getByteCount();
        Long packetCount = ((FbTrigger)this.entity).getPacketCount();
        double throughput = EthernetThroughputUtility.calculateThroughputBitsPerSecond(byteCount, packetCount, throughputType, durationSeconds);
        return throughput;
    }

    public Long getByteCount() {
        return ((FbTrigger)this.entity).getByteCount();
    }

    public Double getFrameRate() {
        Double durationSeconds = this.getDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        return (double)((FbTrigger)this.entity).getPacketCount() / durationSeconds;
    }

    public Long getDurationNanoseconds() {
        if (((FbTrigger)this.entity).getFirstPacketTime() == null || ((FbTrigger)this.entity).getLastPacketTime() == null) {
            return null;
        }
        return ((FbTrigger)this.entity).getLastPacketTime() - ((FbTrigger)this.entity).getFirstPacketTime();
    }

    public Double getDurationSeconds() {
        Long durationNs = this.getDurationNanoseconds();
        if (durationNs == null) {
            return null;
        }
        return UnitReader.convert((double)durationNs, UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }
}

