/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.QueryWithEntityManager;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestStatus;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.ResultsOverTimeUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpSessionReader
extends BaseEntityReader<HttpSession> {
    HttpSessionReader(HttpSession entity) {
        super(entity);
    }

    public HttpSessionSnapshot getFirstSnapshot() {
        List<HttpSessionSnapshot> snapshots = ((HttpSession)this.entity).getSnapshots();
        if (snapshots.size() > 0) {
            return snapshots.get(0);
        }
        return null;
    }

    public HttpSessionSnapshot getLatestSnapshot() {
        return ((HttpSession)this.entity).getLatestSnapshot();
    }

    public TypedQuery<HttpSessionSnapshot> getSnapshotsQuery(EntityManager entityManager) {
        return this.getSnapshotsQuery(entityManager, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public TypedQuery<HttpSessionSnapshot> getSnapshotsQuery(EntityManager entityManager, long start, long end) {
        Query query = entityManager.createNativeQuery(" SELECT snapshot_time, snapshot_duration, tx_byte_count, rx_byte_count  FROM http_session_snapshot  WHERE http_session_id = ? AND ? <= snapshot_time  AND snapshot_time < ?  ORDER BY snapshot_time ASC");
        query.setParameter(1, (Object)((HttpSession)this.entity).getId());
        query.setParameter(2, (Object)start);
        query.setParameter(3, (Object)end);
        QueryProxy bridgeQuery = new QueryProxy(query, entityManager, (HttpSession)this.entity);
        return bridgeQuery;
    }

    public List<HttpSessionSnapshotReader> getSnapshotReaders() {
        ArrayList<HttpSessionSnapshotReader> snapshotReaders = new ArrayList<HttpSessionSnapshotReader>();
        for (HttpSessionSnapshot snapshot : ((HttpSession)this.entity).getSnapshots()) {
            snapshotReaders.add(EntityReaderFactory.create(snapshot));
        }
        return snapshotReaders;
    }

    public HttpSessionSnapshotReader getLatestSnapshotReader() {
        HttpSessionSnapshot latestSnapshot = this.getLatestSnapshot();
        if (latestSnapshot == null) {
            return null;
        }
        return EntityReaderFactory.create(this.getLatestSnapshot());
    }

    public Double getTxThroughput(DataRateUnit dataRateUnit) {
        return ThroughputReader.convertThroughput(this.getTxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getRxThroughput(DataRateUnit dataRateUnit) {
        Double throughputBps = this.getRxThroughputBps();
        if (throughputBps == null) {
            return null;
        }
        return ThroughputReader.convertThroughput(this.getRxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getTxThroughputBps() {
        Double durationSeconds = this.getTxDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        return ThroughputReader.convertBytesToBits((double)((HttpSession)this.entity).getTxByteCount()) / durationSeconds;
    }

    public Double getRxThroughputBps() {
        Double durationSeconds = this.getRxDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        return ThroughputReader.convertBytesToBits((double)((HttpSession)this.entity).getRxByteCount()) / durationSeconds;
    }

    public Long getTxDurationNanoseconds() {
        if (((HttpSession)this.entity).getTxFirstByteTime() == null || ((HttpSession)this.entity).getTxLastByteTime() == null) {
            return null;
        }
        return ((HttpSession)this.entity).getTxLastByteTime() - ((HttpSession)this.entity).getTxFirstByteTime();
    }

    public Double getTxDurationSeconds() {
        Long durationNs = this.getTxDurationNanoseconds();
        if (durationNs == null) {
            return null;
        }
        return UnitReader.convert((double)durationNs, UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }

    public String getTxDuration() {
        Long nanos = this.getTxDurationNanoseconds();
        if (nanos == null) {
            return "N/A";
        }
        HighResolutionCalendar duration = new HighResolutionCalendar(nanos);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)duration);
    }

    public Long getRxDurationNanoseconds() {
        if (((HttpSession)this.entity).getRxFirstByteTime() == null || ((HttpSession)this.entity).getRxLastByteTime() == null) {
            return null;
        }
        return ((HttpSession)this.entity).getRxLastByteTime() - ((HttpSession)this.entity).getRxFirstByteTime();
    }

    public String getRxDuration() {
        Long nanos = this.getRxDurationNanoseconds();
        if (nanos == null) {
            return "N/A";
        }
        HighResolutionCalendar duration = new HighResolutionCalendar(nanos);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)duration);
    }

    public Double getRxDurationSeconds() {
        Long durationNs = this.getRxDurationNanoseconds();
        if (durationNs == null) {
            return null;
        }
        return UnitReader.convert((double)durationNs, UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }

    public SortedMap<Date, Double> getRxThroughputOverTime(EthernetThroughputType throughputType, DataRateUnit dataRateUnit, ResultsOverTimeUtility.BucketChartType chartType, HttpRequestStatus requestStatus) {
        if (this.getSnapshotReaders().isEmpty()) {
            return new TreeMap<Date, Double>();
        }
        ArrayList<ResultsOverTimeUtility.BucketDataPoint> dataPoints = new ArrayList<ResultsOverTimeUtility.BucketDataPoint>();
        for (HttpSessionSnapshotReader snapshotReader : this.getSnapshotReaders()) {
            dataPoints.add(new ResultsOverTimeUtility.BucketDataPoint(snapshotReader.getRxThroughput(dataRateUnit), snapshotReader.getSnapshotTimeNs(), snapshotReader.getSnapshotDurationNs()));
        }
        boolean missingFirst = this.getFirstSnapshot().getSnapshotTime() > ((HttpSession)this.entity).getRxFirstByteTime();
        boolean missingLast = requestStatus != HttpRequestStatus.FINISHED;
        return ResultsOverTimeUtility.getChartValuePointsDate(chartType, ((HttpSession)this.entity).getSnapshotResolution(), dataPoints, missingFirst, missingLast);
    }

    private final class QueryProxy
    implements TypedQuery<HttpSessionSnapshot>,
    QueryWithEntityManager {
        private final Query query;
        private final EntityManager entityManager;
        private final HttpSession session;

        private QueryProxy(Query query, EntityManager entityManager, HttpSession entity) {
            this.query = query;
            this.entityManager = entityManager;
            this.session = entity;
        }

        public <T> T unwrap(Class<T> arg0) {
            return (T)this.query.unwrap(arg0);
        }

        public boolean isBound(Parameter<?> arg0) {
            return this.query.isBound(arg0);
        }

        public Set<Parameter<?>> getParameters() {
            return this.query.getParameters();
        }

        public Object getParameterValue(int arg0) {
            return this.query.getParameterValue(arg0);
        }

        public Object getParameterValue(String arg0) {
            return this.query.getParameterValue(arg0);
        }

        public <T> T getParameterValue(Parameter<T> arg0) {
            return (T)this.query.getParameterValue(arg0);
        }

        public <T> Parameter<T> getParameter(int arg0, Class<T> arg1) {
            return this.query.getParameter(arg0, arg1);
        }

        public <T> Parameter<T> getParameter(String arg0, Class<T> arg1) {
            return this.query.getParameter(arg0, arg1);
        }

        public Parameter<?> getParameter(int arg0) {
            return this.query.getParameter(arg0);
        }

        public Parameter<?> getParameter(String arg0) {
            return this.query.getParameter(arg0);
        }

        public int getMaxResults() {
            return this.query.getMaxResults();
        }

        public LockModeType getLockMode() {
            return this.query.getLockMode();
        }

        public Map<String, Object> getHints() {
            return this.query.getHints();
        }

        public FlushModeType getFlushMode() {
            return this.query.getFlushMode();
        }

        public int getFirstResult() {
            return this.query.getFirstResult();
        }

        public int executeUpdate() {
            return this.query.executeUpdate();
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(int arg0, Date arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(int arg0, Calendar arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(String arg0, Date arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(String arg0, Calendar arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(Parameter<Date> arg0, Date arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(Parameter<Calendar> arg0, Calendar arg1, TemporalType arg2) {
            this.query.setParameter(arg0, arg1, arg2);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(int arg0, Object arg1) {
            this.query.setParameter(arg0, arg1);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setParameter(String arg0, Object arg1) {
            this.query.setParameter(arg0, arg1);
            return this;
        }

        public <T> TypedQuery<HttpSessionSnapshot> setParameter(Parameter<T> arg0, T arg1) {
            this.query.setParameter(arg0, arg1);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setMaxResults(int arg0) {
            this.query.setMaxResults(arg0);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setLockMode(LockModeType arg0) {
            this.query.setLockMode(arg0);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setHint(String arg0, Object arg1) {
            this.query.setHint(arg0, arg1);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setFlushMode(FlushModeType arg0) {
            this.query.setFlushMode(arg0);
            return this;
        }

        public TypedQuery<HttpSessionSnapshot> setFirstResult(int arg0) {
            this.query.setFirstResult(arg0);
            return this;
        }

        public HttpSessionSnapshot getSingleResult() {
            Object[] result = (Object[])this.query.getSingleResult();
            Long time = (Long)result[0];
            Long duration = (Long)result[1];
            Long tx_bytes = (Long)result[2];
            Long rx_bytes = (Long)result[3];
            return new HttpSessionSnapshot(this.session, time, duration, tx_bytes, rx_bytes);
        }

        public List<HttpSessionSnapshot> getStreamingResultList() {
            Stream<HttpSessionSnapshot> streamSnap = this.query.getResultList().stream().map(baseResult -> {
                Object[] current = (Object[])baseResult;
                Long time = (Long)current[0];
                Long duration = (Long)current[1];
                Long tx_bytes = (Long)current[2];
                Long rx_bytes = (Long)current[3];
                HttpSessionSnapshot snap = new HttpSessionSnapshot(this.session, time, duration, tx_bytes, rx_bytes);
                return snap;
            });
            return streamSnap.collect(Collectors.toList());
        }

        public List<HttpSessionSnapshot> getResultList() {
            ArrayList<HttpSessionSnapshot> result = new ArrayList<HttpSessionSnapshot>();
            for (Object baseResult : this.query.getResultList()) {
                Object[] current = (Object[])baseResult;
                Long time = (Long)current[0];
                Long duration = (Long)current[1];
                Long tx_bytes = (Long)current[2];
                Long rx_bytes = (Long)current[3];
                HttpSessionSnapshot snap = new HttpSessionSnapshot(this.session, time, duration, tx_bytes, rx_bytes);
                result.add(snap);
            }
            return result;
        }

        @Override
        public EntityManager getEntityManager() {
            return this.entityManager;
        }
    }
}

