/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.enums;

public enum Ipv6AddressType {
    DHCP_AUTO(Ipv6AddressSource.DHCP, Ipv6AddressCause.AUTO),
    DHCP_FORCED(Ipv6AddressSource.DHCP, Ipv6AddressCause.FORCED),
    SLAAC_AUTO_MAC(Ipv6AddressSource.SLAAC, Ipv6AddressCause.AUTO, Ipv6AddressHostAddress.MAC),
    SLAAC_AUTO_RANDOM(Ipv6AddressSource.SLAAC, Ipv6AddressCause.AUTO, Ipv6AddressHostAddress.RANDOM),
    SLAAC_FORCED_MAC(Ipv6AddressSource.SLAAC, Ipv6AddressCause.FORCED, Ipv6AddressHostAddress.MAC),
    SLAAC_FORCED_RANDOM(Ipv6AddressSource.SLAAC, Ipv6AddressCause.FORCED, Ipv6AddressHostAddress.RANDOM),
    FIXED(Ipv6AddressSource.FIXED);

    private Ipv6AddressSource source;
    private Ipv6AddressCause cause;
    private Ipv6AddressHostAddress hostAddress;

    private Ipv6AddressType(Ipv6AddressSource source) {
        this(source, null, null);
    }

    private Ipv6AddressType(Ipv6AddressSource source, Ipv6AddressCause cause) {
        this(source, cause, null);
    }

    private Ipv6AddressType(Ipv6AddressSource source, Ipv6AddressCause cause, Ipv6AddressHostAddress hostAddress) {
        this.source = source;
        this.cause = cause;
        this.hostAddress = hostAddress;
    }

    public String toString() {
        return (Object)((Object)this.source) + (this.cause == null ? "" : ", " + (Object)((Object)this.cause)) + (this.hostAddress == null ? "" : ", " + (Object)((Object)this.hostAddress) + " address");
    }

    private static enum Ipv6AddressCause {
        FORCED("Forced"),
        AUTO("Network determined");

        private String description;

        private Ipv6AddressCause(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static enum Ipv6AddressHostAddress {
        MAC("MAC based"),
        RANDOM("Random generated");

        private String description;

        private Ipv6AddressHostAddress(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static enum Ipv6AddressSource {
        DHCP("DHCP"),
        SLAAC("SLAAC"),
        FIXED("Manually added");

        private String description;

        private Ipv6AddressSource(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

