/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.utils.ConversionHelper;
import java.util.regex.Pattern;

public class Ipv4AddressUtility {
    private Ipv4AddressUtility() {
    }

    public static byte[] convertToBinary(String ipv4AddressString) throws TestDataPersistenceConversionError {
        String[] parts = Pattern.compile("\\.").split(ipv4AddressString);
        if (parts.length != 4) {
            throw new TestDataPersistenceConversionError("Cannot convert IPv4 address to binary; illegal address format '" + ipv4AddressString + "' (need 4 decimal groups)");
        }
        String hexString = "";
        int i = 0;
        while (i < 4) {
            int number;
            try {
                number = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException ex) {
                throw new TestDataPersistenceConversionError("Cannot convert IPv4 address to binary; illegal address format '" + ipv4AddressString + "' (need 4 decimal groups)");
            }
            if (number < 0 || number > 255) {
                throw new TestDataPersistenceConversionError("Cannot convert IPv4 address to binary; illegal address format '" + ipv4AddressString + "' (decimal values in range 0..255)");
            }
            hexString = String.valueOf(hexString) + String.format("%02x", number);
            ++i;
        }
        return ConversionHelper.hexStringToByteArray(hexString);
    }

    public static String convertToString(byte[] ipv4Address) throws TestDataPersistenceConversionError {
        if (ipv4Address.length != 4) {
            throw new TestDataPersistenceConversionError("Cannot convert IPv4 address binary to string; expected 4 bytes");
        }
        return String.valueOf(Ipv4AddressUtility.convert(ipv4Address, 0)) + "." + Ipv4AddressUtility.convert(ipv4Address, 1) + "." + Ipv4AddressUtility.convert(ipv4Address, 2) + "." + Ipv4AddressUtility.convert(ipv4Address, 3);
    }

    private static String convert(byte[] ipv4Address, int i) {
        int value = ipv4Address[i];
        if (value < 0) {
            value += 256;
        }
        return Integer.toString(value);
    }

    public static int convertIpv4NetmaskToPrefixLength(String ipv4NetmaskString) throws TestDataPersistenceConversionError {
        try {
            long ipv4Long = Ipv4AddressUtility.convertIpv4AddressStringToLong(ipv4NetmaskString);
            return Ipv4AddressUtility.convertIpv4LongToPrefixLength(ipv4Long);
        }
        catch (TestDataPersistenceConversionError ex) {
            throw new TestDataPersistenceConversionError("Cannot convert IPv4 netmask to int; illegal netmask format " + ipv4NetmaskString, ex);
        }
    }

    public static String convertPrefixLengthToIpv4Netmask(int ipv4NetmaskLength) throws TestDataPersistenceConversionError {
        long ones = 0xFFFFFFFFL;
        long ipv4Long = 0xFFFFFFFFL << 32 - ipv4NetmaskLength & 0xFFFFFFFFL;
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            byte value;
            bytes[i] = value = (byte)(ipv4Long >> (4 - i - 1 << 3));
            ++i;
        }
        return Ipv4AddressUtility.convertToString(bytes);
    }

    private static long convertIpv4AddressStringToLong(String ipv4Address) throws TestDataPersistenceConversionError {
        String[] parts = Pattern.compile("\\.").split(ipv4Address);
        if (parts.length != 4) {
            throw new TestDataPersistenceConversionError("Cannot convert IPv4 address to long; illegal address format " + ipv4Address);
        }
        try {
            long n1 = Integer.parseInt(parts[0]) & 0xFF;
            long n2 = Integer.parseInt(parts[1]) & 0xFF;
            long n3 = Integer.parseInt(parts[2]) & 0xFF;
            long n4 = Integer.parseInt(parts[3]) & 0xFF;
            return (n1 << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        }
        catch (NumberFormatException ex) {
            throw new TestDataPersistenceConversionError("Cannot convert IPv4 address to long; illegal address format " + ipv4Address);
        }
    }

    private static int convertIpv4LongToPrefixLength(long ipv4Long) throws TestDataPersistenceConversionError {
        try {
            int count = 0;
            while ((ipv4Long << count & 0xFFFFFFFFL) != 0L) {
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            throw new TestDataPersistenceConversionError("Unexpected conversion exception", e);
        }
    }
}

