-- -----------------------------------------------------
-- Table `scenario`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `scenario` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `status` VARCHAR(40) NOT NULL,
  `init_start_time` TIMESTAMP NULL,
  `init_end_time` TIMESTAMP NULL,
  `run_start_time` TIMESTAMP NULL,
  `run_end_time` TIMESTAMP NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_scenario_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `ipv4_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `ipv4_address` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `address` BINARY(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_ipv4_address` (`address` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `server`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `server` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `UUID` VARCHAR(45) NOT NULL,
  `url` VARCHAR(21844) NOT NULL,
  `connection_state` VARCHAR(40) NOT NULL,
  `type` VARCHAR(40) NULL,
  `ipv4_address_id` BIGINT(20) NULL,
  `version` VARCHAR(40) NULL,
  `name` VARCHAR(128) NULL,
  `description` VARCHAR(21844) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_server_ipv4address` (`ipv4_address_id` ASC),
  UNIQUE INDEX `UUID_UNIQUE` (`UUID` ASC),
  CONSTRAINT `fk_server_ipv4address`
    FOREIGN KEY (`ipv4_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `interface`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `interface` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `server_id` BIGINT(20) NOT NULL,
  `code` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_interface_server` (`server_id` ASC),
  CONSTRAINT `fk_interface_server`
    FOREIGN KEY (`server_id`)
    REFERENCES `server` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `port`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `port` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `interface_id` BIGINT(20) NOT NULL,
  `status` VARCHAR(40) NOT NULL,
  `mtu` INT(10) NOT NULL,
  `docked` VARCHAR(1000) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_port_interface` (`interface_id` ASC),
  UNIQUE INDEX `uq_port_name` (`name` ASC),
  CONSTRAINT `fk_port_interface`
    FOREIGN KEY (`interface_id`)
    REFERENCES `interface` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `application`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `application` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `scenario_id` BIGINT(20) NOT NULL,
  `port_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_application_scenario` (`scenario_id` ASC),
  INDEX `fk_application_port` (`port_id` ASC),
  CONSTRAINT `fk_application_scenario`
    FOREIGN KEY (`scenario_id`)
    REFERENCES `scenario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_application_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `http_application`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `http_application` (
  `id` BIGINT(20) NOT NULL,
  `type_http` VARCHAR(40) NOT NULL,
  `port_number` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_http_application_parent` (`id` ASC),
  CONSTRAINT `fk_http_application_parent`
    FOREIGN KEY (`id`)
    REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `state` VARCHAR(40) NULL,
  `ca_algorithm` VARCHAR(40) NULL,
  `maximum_segment_size` INT(10) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `http_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `http_session` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `application_http_id` BIGINT(20) NOT NULL,
  `tcp_session_id` BIGINT(20) NOT NULL,
  `tx_first_byte_time` BIGINT(20) NULL,
  `tx_last_byte_time` BIGINT(20) NULL,
  `rx_first_byte_time` BIGINT(20) NULL,
  `rx_last_byte_time` BIGINT(20) NULL,
  `tx_byte_count` BIGINT(20) NULL,
  `rx_byte_count` BIGINT(20) NULL,
  `snapshot_resolution` BIGINT(20) NULL,
  `tx_header_byte_count` BIGINT(20) NULL,
  `tx_payload_byte_count` BIGINT(20) NULL,
  `rx_header_byte_count` BIGINT(20) NULL,
  `rx_payload_byte_count` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_http_session_tcp` (`tcp_session_id` ASC),
  INDEX `fk_http_session_application` (`application_http_id` ASC),
  INDEX `fk_http_session_tcp` (`tcp_session_id` ASC),
  CONSTRAINT `fk_http_session_application`
    FOREIGN KEY (`application_http_id`)
    REFERENCES `http_application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_http_session_tcp`
    FOREIGN KEY (`tcp_session_id`)
    REFERENCES `tcp_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `tcp_session_id` BIGINT(20) NOT NULL,
  `snapshot_time` BIGINT(20) NOT NULL,
  `snapshot_duration` BIGINT(20) NOT NULL,
  `connection_state` VARCHAR(4) NOT NULL,
  `congestion_window_minimum` BIGINT(20) NOT NULL,
  `congestion_window_current` BIGINT(20) NOT NULL,
  `congestion_window_maximum` BIGINT(20) NOT NULL,
  `receiver_window_minimum` BIGINT(20) NOT NULL,
  `receiver_window_current` BIGINT(20) NOT NULL,
  `receiver_window_maximum` BIGINT(20) NOT NULL,
  `slow_start_threshold_minimum` BIGINT(20) NOT NULL,
  `slow_start_threshold_current` BIGINT(20) NOT NULL,
  `slow_start_threshold_maximum` BIGINT(20) NOT NULL,
  `roundtriptime_minimum` BIGINT(20) NOT NULL,
  `roundtriptime_current` BIGINT(20) NOT NULL,
  `roundtriptime_maximum` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_tcp_session_snapshot_owner` (`tcp_session_id` ASC),
  CONSTRAINT `fk_tcp_session_snapshot_owner`
    FOREIGN KEY (`tcp_session_id`)
    REFERENCES `tcp_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mac_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mac_address` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `address` BINARY(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_mac_address` (`address` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `address_resolution`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `address_resolution` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `scenario_id` BIGINT(20) NOT NULL,
  `resolver_port_id` BIGINT(20) NOT NULL,
  `mac_address_id` BIGINT(20) NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_address_resolution_scenario` (`scenario_id` ASC),
  INDEX `fk_address_resolution_resolverport` (`resolver_port_id` ASC),
  INDEX `fk_address_resolution_macaddress` (`mac_address_id` ASC),
  CONSTRAINT `fk_address_resolution_scenario`
    FOREIGN KEY (`scenario_id`)
    REFERENCES `scenario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_address_resolution_resolverport`
    FOREIGN KEY (`resolver_port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_address_resolution_macaddress`
    FOREIGN KEY (`mac_address_id`)
    REFERENCES `mac_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `ipv6_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `ipv6_address` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `address` BINARY(16) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_ipv6_address` (`address` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer2`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer2` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `port_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer2_port` (`port_id` ASC),
  UNIQUE INDEX `uq_layer2_port` (`port_id` ASC),
  CONSTRAINT `fk_layer2_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer25`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer25` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `layer2_id` BIGINT(20) NOT NULL,
  `upper_layer25_id` BIGINT(20) NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer25_baselayer2` (`layer2_id` ASC),
  INDEX `fk_layer25_upperlayer25` (`upper_layer25_id` ASC),
  CONSTRAINT `fk_layer25_baselayer2`
    FOREIGN KEY (`layer2_id`)
    REFERENCES `layer2` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer25_upperlayer25`
    FOREIGN KEY (`upper_layer25_id`)
    REFERENCES `layer25` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer25_vlan_configuration`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer25_vlan_configuration` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `vlan` INT(10) NOT NULL,
  `priority` INT(10) NOT NULL,
  `drop_eligible` TINYINT(1) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `port_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_layer3_port` (`port_id` ASC),
  INDEX `fk_layer3_port` (`port_id` ASC),
  CONSTRAINT `fk_layer3_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv4_configuration_dhcpv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv4_configuration_dhcpv4` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `discover_initial_timeout` BIGINT(20) NOT NULL,
  `discover_max_retries` INT(10) NOT NULL,
  `request_initial_timeout` BIGINT(20) NOT NULL,
  `request_max_retries` INT(10) NOT NULL,
  `retransmission_policy` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_layer3_ipv4_configuration_dhcpv4_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv4_configuration_static`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv4_configuration_static` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `address_id` BIGINT(20) NOT NULL,
  `gateway_address_id` BIGINT(20) NOT NULL,
  `netmask_value` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv4_configuration_static_ipaddress` (`address_id` ASC),
  INDEX `fk_layer3_ipv4_configuration_static_gwaddress` (`gateway_address_id` ASC),
  CONSTRAINT `fk_layer3_ipv4_configuration_static_ipaddress`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_configuration_static_gwaddress`
    FOREIGN KEY (`gateway_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `ipv4_nat_configuration`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `ipv4_nat_configuration` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv4` (
  `id` BIGINT(20) NOT NULL,
  `method` VARCHAR(40) NOT NULL,
  `dhcp_configuration_id` BIGINT(20) NULL,
  `static_configuration_id` BIGINT(20) NULL,
  `nat_configuration_id` INT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv4_parent` (`id` ASC),
  INDEX `fk_layer3_ipv4_dhcpconfig` (`dhcp_configuration_id` ASC),
  INDEX `fk_layer3_ipv4_staticconfig` (`static_configuration_id` ASC),
  INDEX `fk_layer3_ipv4_natconfig_idx` (`nat_configuration_id` ASC),
  CONSTRAINT `fk_layer3_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `layer3` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_dhcpconfig`
    FOREIGN KEY (`dhcp_configuration_id`)
    REFERENCES `layer3_ipv4_configuration_dhcpv4` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_staticconfig`
    FOREIGN KEY (`static_configuration_id`)
    REFERENCES `layer3_ipv4_configuration_static` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_natconfig`
    FOREIGN KEY (`nat_configuration_id`)
    REFERENCES `ipv4_nat_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_configuration_dhcpv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_configuration_dhcpv6` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `solicit_initial_timeout` BIGINT(20) NOT NULL,
  `solicit_max_retries` INT(10) NOT NULL,
  `request_initial_timeout` BIGINT(20) NOT NULL,
  `request_max_retries` INT(10) NOT NULL,
  `retransmission_policy` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_layer3_ipv6_configuration_dhcpv6_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_configuration_slaac`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_configuration_slaac` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `placeholder` TINYINT(1) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_configuration_static`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_configuration_static` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `placeholder` TINYINT(1) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6` (
  `id` BIGINT(20) NOT NULL,
  `dhcp_policy` VARCHAR(40) NOT NULL,
  `dhcp_configuration_id` BIGINT(20) NULL,
  `slaac_policy` VARCHAR(40) NOT NULL,
  `slaac_configuration_id` BIGINT(20) NULL,
  `static_configuration_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_parent` (`id` ASC),
  INDEX `fk_layer3_ipv6_dhcpconfig` (`dhcp_configuration_id` ASC),
  INDEX `fk_layer3_ipv6_fixedconfig` (`static_configuration_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `layer3` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_dhcpconfig`
    FOREIGN KEY (`dhcp_configuration_id`)
    REFERENCES `layer3_ipv6_configuration_dhcpv6` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_slaacconfig`
    FOREIGN KEY (`slaac_configuration_id`)
    REFERENCES `layer3_ipv6_configuration_slaac` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_fixedconfig`
    FOREIGN KEY (`static_configuration_id`)
    REFERENCES `layer3_ipv6_configuration_static` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `nat_mapping_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `nat_mapping_address` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `scenario_id` BIGINT(20) NOT NULL,
  `resolver_port_id` BIGINT(20) NOT NULL,
  `target_port_id` BIGINT(20) NOT NULL,
  `public_address_id` BIGINT(20) NULL,
  `method` VARCHAR(21844) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_nat_mapping_address_resolverport` (`resolver_port_id` ASC),
  INDEX `fk_nat_mapping_address_targetport` (`target_port_id` ASC),
  INDEX `fk_nat_mapping_address_publicip` (`public_address_id` ASC),
  INDEX `fk_nat_mapping_address_scenario` (`scenario_id` ASC),
  CONSTRAINT `fk_nat_mapping_address_resolverport`
    FOREIGN KEY (`resolver_port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_nat_mapping_address_targetport`
    FOREIGN KEY (`target_port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_nat_mapping_address_publicip`
    FOREIGN KEY (`public_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_nat_mapping_address_scenario`
    FOREIGN KEY (`scenario_id`)
    REFERENCES `scenario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `event_time` TIMESTAMP NOT NULL,
  `description` VARCHAR(21844) NOT NULL,
  `severity` VARCHAR(40) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  `suggestion` VARCHAR(21844) NULL,
  `knowledgebase_link` VARCHAR(1024) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_nat_mapping_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_nat_mapping_address` (
  `id` BIGINT(20) NOT NULL,
  `nat_mapping_address_id` BIGINT(20) NULL,
  INDEX `fk_event_nat_mapping_address_parent` (`id` ASC),
  PRIMARY KEY (`id`),
  INDEX `fk_event_nat_mapping_address_content` (`nat_mapping_address_id` ASC),
  CONSTRAINT `fk_event_nat_mapping_address_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_nat_mapping_address_content`
    FOREIGN KEY (`nat_mapping_address_id`)
    REFERENCES `nat_mapping_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `nat_mapping_port`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `nat_mapping_port` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `nat_mapping_address_id` BIGINT(20) NOT NULL,
  `protocol` VARCHAR(40) NOT NULL,
  `private_port` INT(10) NOT NULL,
  `public_port` INT(10) NULL,
  `method` VARCHAR(21844) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_nat_mapping_port_addressmapping` (`nat_mapping_address_id` ASC),
  CONSTRAINT `fk_nat_mapping_port_addressmapping`
    FOREIGN KEY (`nat_mapping_address_id`)
    REFERENCES `nat_mapping_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_flow_template`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_flow_template` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `frame_interval` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_fb_flow_template_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_stream_timingmodifier`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_stream_timingmodifier` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `fb_flow_template_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_stream_timingmodifier_flowtemplate` (`fb_flow_template_id` ASC),
  UNIQUE INDEX `uq_fb_stream_timingmodifier_flowtemplate` (`fb_flow_template_id` ASC),
  CONSTRAINT `fk_fb_stream_timingmodifier_flowtemplate`
    FOREIGN KEY (`fb_flow_template_id`)
    REFERENCES `fb_flow_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_fb_frame_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_sizemodifier_growing`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_sizemodifier_growing` (
  `id` BIGINT(20) NOT NULL,
  `min_size` INT(10) NOT NULL,
  `max_size` INT(10) NOT NULL,
  `step_size` INT(10) NOT NULL,
  `frame_iteration` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_frame_sizemodifier_growing_parent` (`id` ASC),
  CONSTRAINT `fk_fb_frame_sizemodifier_growing_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `http_flow_template`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `http_flow_template` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `http_request_method` VARCHAR(40) NOT NULL,
  `http_data_size` BIGINT(20) NULL,
  `rate_limitation` BIGINT(20) NULL,
  `client_port` INT(10) NULL,
  `server_port` INT(10) NULL,
  `ca_algorithm` VARCHAR(40) NOT NULL,
  `rx_window_initial_unscaled_size` INT(10) NULL,
  `rx_window_scale_value` INT(10) NULL,
  `is_l4s_enabled` TINYINT(1) NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_http_flow_template_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_stream_timingmodifier_multiburst`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_stream_timingmodifier_multiburst` (
  `id` BIGINT(20) NOT NULL,
  `inter_burst_gap` BIGINT(20) NULL,
  `frames_per_burst` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_stream_timingmodifier_multiburst_parent` (`id` ASC),
  CONSTRAINT `fk_fb_stream_timingmodifier_multiburst_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_stream_timingmodifier` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_sizemodifier_random`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_sizemodifier_random` (
  `id` BIGINT(20) NOT NULL,
  `min_size` INT(10) NOT NULL,
  `max_size` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_frame_sizemodifier_random_parent` (`id` ASC),
  CONSTRAINT `fk_fb_frame_sizemodifier_random_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_server`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_server` (
  `id` BIGINT(20) NOT NULL,
  `server_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_server_parent` (`id` ASC),
  INDEX `fk_event_server_content` (`server_id` ASC),
  CONSTRAINT `fk_event_server_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_server_content`
    FOREIGN KEY (`server_id`)
    REFERENCES `server` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `test`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `test` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `project_name` VARCHAR(21844) NOT NULL,
  `project_author` VARCHAR(21844) NOT NULL,
  `project_version` VARCHAR(40) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  `name` VARCHAR(21844) NOT NULL,
  `run_title` VARCHAR(21844) NOT NULL,
  `status` VARCHAR(40) NOT NULL,
  `init_start_time` TIMESTAMP NULL,
  `init_end_time` TIMESTAMP NULL,
  `run_start_time` TIMESTAMP NULL,
  `run_end_time` TIMESTAMP NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer2_ethernet2`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer2_ethernet2` (
  `id` BIGINT(20) NOT NULL,
  `mac_address_id` BIGINT(20) NOT NULL,
  INDEX `fk_layer2_ethernet2_parent` (`id` ASC),
  INDEX `fk_layer2_ethernet2_macaddress` (`mac_address_id` ASC),
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_layer2_ethernet2_parent`
    FOREIGN KEY (`id`)
    REFERENCES `layer2` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer2_ethernet2_macaddress`
    FOREIGN KEY (`mac_address_id`)
    REFERENCES `mac_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_session` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `layer3_ipv6_id` BIGINT(20) NOT NULL,
  `linklocal_address_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_session_protocol` (`layer3_ipv6_id` ASC),
  INDEX `fk_layer3_ipv6_session_linklocaladdress` (`linklocal_address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_session_protocol`
    FOREIGN KEY (`layer3_ipv6_id`)
    REFERENCES `layer3_ipv6` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_session_linklocaladdress`
    FOREIGN KEY (`linklocal_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_session_prefix`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_session_prefix` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `session_id` BIGINT(20) NOT NULL,
  `network_address_id` BIGINT(20) NOT NULL,
  `prefix_length` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_session_prefix_session` (`session_id` ASC),
  INDEX `fk_layer3_ipv6_session_prefix_address` (`network_address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_session_prefix_session`
    FOREIGN KEY (`session_id`)
    REFERENCES `layer3_ipv6_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_session_prefix_address`
    FOREIGN KEY (`network_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_session_address`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_session_address` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `prefix_id` BIGINT(20) NOT NULL,
  `address_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_session_address_prefix` (`prefix_id` ASC),
  INDEX `fk_layer3_ipv6_session_address_address` (`address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_session_address_prefix`
    FOREIGN KEY (`prefix_id`)
    REFERENCES `layer3_ipv6_session_prefix` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_session_address_address`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `flow`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `flow` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_flow_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `flow_instance`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `flow_instance` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `scenario_id` BIGINT(20) NOT NULL,
  `flow_id` BIGINT(20) NOT NULL,
  `scenario_position` INT(10) NOT NULL,
  `start_time` BIGINT(20) NOT NULL,
  `duration` BIGINT(20) NULL,
  `type` VARCHAR(40) NOT NULL,
  `parent` BIGINT(20) NULL,
  `status` VARCHAR(40) NOT NULL,
  `tos` VARCHAR(45) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_flow_instance_scenario` (`scenario_id` ASC),
  INDEX `fk_flow_instance_flow` (`flow_id` ASC),
  CONSTRAINT `fk_flow_instance_scenario`
    FOREIGN KEY (`scenario_id`)
    REFERENCES `scenario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_flow_instance_flow`
    FOREIGN KEY (`flow_id`)
    REFERENCES `flow` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `http_flow_instance`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `http_flow_instance` (
  `id` BIGINT(20) NOT NULL,
  `http_flow_template_id` BIGINT(20) NOT NULL,
  `request_method` VARCHAR(40) NULL,
  `request_status` VARCHAR(40) NULL,
  `client_http_session_id` BIGINT(20) NULL,
  `server_http_session_id` BIGINT(20) NULL,
  `restarts` BIGINT(20) NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  INDEX `fk_http_flow_instance_parent` (`id` ASC),
  INDEX `fk_http_flow_instance_flowtemplate` (`http_flow_template_id` ASC),
  INDEX `fk_http_flow_instance_clientsession` (`client_http_session_id` ASC),
  INDEX `fk_http_flow_instance_serversession` (`server_http_session_id` ASC),
  CONSTRAINT `fk_http_flow_instance_parent`
    FOREIGN KEY (`id`)
    REFERENCES `flow_instance` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_http_flow_instance_flowtemplate`
    FOREIGN KEY (`http_flow_template_id`)
    REFERENCES `http_flow_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_http_flow_instance_clientsession`
    FOREIGN KEY (`client_http_session_id`)
    REFERENCES `http_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_http_flow_instance_serversession`
    FOREIGN KEY (`server_http_session_id`)
    REFERENCES `http_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `http_session_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `http_session_snapshot` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `http_session_id` BIGINT(20) NOT NULL,
  `snapshot_time` BIGINT(20) NOT NULL,
  `snapshot_duration` BIGINT(20) NOT NULL,
  `tx_byte_count` BIGINT(20) NOT NULL,
  `rx_byte_count` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_http_session_snapshot_owner` (`http_session_id` ASC),
  CONSTRAINT `fk_http_session_snapshot_owner`
    FOREIGN KEY (`http_session_id`)
    REFERENCES `http_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_flow_instance`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_flow_instance` (
  `id` BIGINT(20) NOT NULL,
  `fb_flow_template_id` BIGINT(20) NOT NULL,
  `frame_count` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_flow_instance_parent` (`id` ASC),
  INDEX `fk_fb_flow_instance_flowtemplate` (`fb_flow_template_id` ASC),
  CONSTRAINT `fk_fb_flow_instance_parent`
    FOREIGN KEY (`id`)
    REFERENCES `flow_instance` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_flow_instance_flowtemplate`
    FOREIGN KEY (`fb_flow_template_id`)
    REFERENCES `fb_flow_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_trigger`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_trigger` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `first_packet_time` BIGINT(20) NULL,
  `last_packet_time` BIGINT(20) NULL,
  `packet_count` BIGINT(20) NOT NULL,
  `byte_count` BIGINT(20) NOT NULL,
  `snapshot_resolution` BIGINT(20) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_source`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_source` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `flow_instance_id` BIGINT(20) NOT NULL,
  `port_id` BIGINT(20) NOT NULL,
  `trigger` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_source_port` (`port_id` ASC),
  UNIQUE INDEX `uq_fb_source_flowinstance` (`flow_instance_id` ASC),
  INDEX `fk_fb_source_flowinstance` (`flow_instance_id` ASC),
  INDEX `fk_fb_source_trigger` (`trigger` ASC),
  CONSTRAINT `fk_fb_source_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_source_flowinstance`
    FOREIGN KEY (`flow_instance_id`)
    REFERENCES `fb_flow_instance` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_source_trigger`
    FOREIGN KEY (`trigger`)
    REFERENCES `fb_trigger` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_trigger_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_trigger_snapshot` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `trigger_id` BIGINT(20) NOT NULL,
  `snapshot_time` BIGINT(20) NOT NULL,
  `snapshot_duration` BIGINT(20) NOT NULL,
  `packet_count` BIGINT(20) NOT NULL,
  `byte_count` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_trigger_snapshot_owner` (`trigger_id` ASC),
  CONSTRAINT `fk_fb_trigger_snapshot_owner`
    FOREIGN KEY (`trigger_id`)
    REFERENCES `fb_trigger` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_trigger_sizedistribution`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_trigger_sizedistribution` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `trigger_id` BIGINT(20) NOT NULL,
  `min_framesize_checked` INT(10) NOT NULL,
  `max_framesize_checked` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_trigger_sizedistribution_parent` (`trigger_id` ASC),
  CONSTRAINT `fk_fb_trigger_sizedistribution_trigger`
    FOREIGN KEY (`trigger_id`)
    REFERENCES `fb_trigger` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_trigger_sizedistribution_entry`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_trigger_sizedistribution_entry` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `distribution_id` BIGINT(20) NOT NULL,
  `size` INT(10) NOT NULL,
  `packet_count` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_trigger_sizedistribution_entry_owner` (`distribution_id` ASC),
  CONSTRAINT `fk_fb_trigger_sizedistribution_entry_owner`
    FOREIGN KEY (`distribution_id`)
    REFERENCES `fb_trigger_sizedistribution` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination_config`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination_config` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `flow_instance_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_fb_destination_config_flowinstance` (`flow_instance_id` ASC),
  INDEX `fk_fb_destination_config_flowinstance` (`flow_instance_id` ASC),
  CONSTRAINT `fk_fb_destination_config_flowinstance`
    FOREIGN KEY (`flow_instance_id`)
    REFERENCES `fb_flow_instance` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_latency`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_latency` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `packet_count_valid` BIGINT(20) NOT NULL,
  `packet_count_invalid` BIGINT(20) NOT NULL,
  `latency_minimum` BIGINT(20) NULL,
  `latency_average` BIGINT(20) NULL,
  `latency_maximum` BIGINT(20) NULL,
  `jitter` BIGINT(20) NULL,
  `latency_precision` BIGINT(20) NULL,
  `snapshot_resolution` BIGINT(20) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_outofsequence`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_outofsequence` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `packet_count_valid` BIGINT(20) NOT NULL,
  `packet_count_invalid` BIGINT(20) NOT NULL,
  `packet_count_outofsequence` BIGINT(20) NOT NULL,
  `snapshot_resolution` BIGINT(20) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `port_id` BIGINT(20) NOT NULL,
  `trigger` BIGINT(20) NULL,
  `latency` BIGINT(20) NULL,
  `outofsequence` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_destination_port` (`port_id` ASC),
  INDEX `fk_fb_destination_trigger` (`trigger` ASC),
  INDEX `fk_fb_destination_latency` (`latency` ASC),
  INDEX `fk_fb_destination_outofsequence` (`outofsequence` ASC),
  CONSTRAINT `fk_fb_destination_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_trigger`
    FOREIGN KEY (`trigger`)
    REFERENCES `fb_trigger` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_latency`
    FOREIGN KEY (`latency`)
    REFERENCES `fb_latency` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_outofsequence`
    FOREIGN KEY (`outofsequence`)
    REFERENCES `fb_outofsequence` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination_config_unicast`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination_config_unicast` (
  `id` BIGINT(20) NOT NULL,
  `fb_destination_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_destination_config_unicast_parent` (`id` ASC),
  UNIQUE INDEX `uq_fb_destination_config_unicast_dest` (`fb_destination_id` ASC),
  INDEX `fk_fb_destination_config_unicast_dest` (`fb_destination_id` ASC),
  CONSTRAINT `fk_fb_destination_config_unicast_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_destination_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_config_unicast_dest`
    FOREIGN KEY (`fb_destination_id`)
    REFERENCES `fb_destination` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination_config_fixed_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination_config_fixed_ipv4` (
  `id` BIGINT(20) NOT NULL,
  `ipv4_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_destination_config_fixed_ipv4_parent` (`id` ASC),
  INDEX `fk_fb_destination_config_fixed_ipv4_ipv4address` (`ipv4_address_id` ASC),
  CONSTRAINT `fk_fb_destination_config_fixed_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_destination_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_config_fixed_ipv4_ipv4address`
    FOREIGN KEY (`ipv4_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_configuration`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_configuration` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_multicast_configuration_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination_config_multicast`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination_config_multicast` (
  `id` BIGINT(20) NOT NULL,
  `multicast_configuration_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_destination_config_multicast_parent` (`id` ASC),
  INDEX `fk_fb_destination_config_multicast_config` (`multicast_configuration_id` ASC),
  CONSTRAINT `fk_fb_destination_config_multicast_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_destination_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_config_multicast_config`
    FOREIGN KEY (`multicast_configuration_id`)
    REFERENCES `multicast_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_eavesdropper_destination`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_eavesdropper_destination` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `fb_destination_config_id` BIGINT(20) NOT NULL,
  `fb_destination_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_fb_eavesdropper_destination_dest` (`fb_destination_id` ASC),
  INDEX `fk_fb_eavesdropper_destination_destconfig` (`fb_destination_config_id` ASC),
  INDEX `fk_fb_eavesdropper_destination_dest` (`fb_destination_id` ASC),
  CONSTRAINT `fk_fb_eavesdropper_destination_destconfig`
    FOREIGN KEY (`fb_destination_config_id`)
    REFERENCES `fb_destination_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_eavesdropper_destination_dest`
    FOREIGN KEY (`fb_destination_id`)
    REFERENCES `fb_destination` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_destination_config_fixed_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_destination_config_fixed_ipv6` (
  `id` BIGINT(20) NOT NULL,
  `ipv6_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_destination_config_fixed_ipv6_parent` (`id` ASC),
  INDEX `fk_fb_destination_config_fixed_ipv6_ipv6address` (`ipv6_address_id` ASC),
  CONSTRAINT `fk_fb_destination_config_fixed_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_destination_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_destination_config_fixed_ipv6_ipv6address`
    FOREIGN KEY (`ipv6_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_multicast_member_destination`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_multicast_member_destination` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `fb_destination_config_multicast_id` BIGINT(20) NOT NULL,
  `fb_destination_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_multicast_member_destination_destconfig` (`fb_destination_config_multicast_id` ASC),
  INDEX `fk_fb_multicast_member_destination_dest` (`fb_destination_id` ASC),
  CONSTRAINT `fk_fb_multicast_member_destination_destconfig`
    FOREIGN KEY (`fb_destination_config_multicast_id`)
    REFERENCES `fb_destination_config_multicast` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_multicast_member_destination_dest`
    FOREIGN KEY (`fb_destination_id`)
    REFERENCES `fb_destination` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_member`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_member` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `multicast_configuration_id` BIGINT(20) NOT NULL,
  `port_id` BIGINT(20) NOT NULL,
  `protocol` VARCHAR(40) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_member_config` (`multicast_configuration_id` ASC),
  INDEX `fk_multicast_member_port` (`port_id` ASC),
  CONSTRAINT `fk_multicast_member_config`
    FOREIGN KEY (`multicast_configuration_id`)
    REFERENCES `multicast_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_member_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_configuration_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_configuration_ipv4` (
  `id` BIGINT(20) NOT NULL,
  `multicast_ipv4_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_configuration_ipv4_parent` (`id` ASC),
  INDEX `fk_multicast_configuration_ipv4_ipv4address` (`multicast_ipv4_address_id` ASC),
  CONSTRAINT `fk_multicast_configuration_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_configuration_ipv4_ipv4address`
    FOREIGN KEY (`multicast_ipv4_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_configuration_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_configuration_ipv6` (
  `id` BIGINT(20) NOT NULL,
  `multicast_ipv6_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_configuration_ipv6_parent` (`id` ASC),
  INDEX `fk_multicast_configuration_ipv6_ipv6address` (`multicast_ipv6_address_id` ASC),
  CONSTRAINT `fk_multicast_configuration_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_configuration_ipv6_ipv6address`
    FOREIGN KEY (`multicast_ipv6_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_sourcegroup`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_sourcegroup` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `uq_multicast_sourcegroup_name` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_member_ssm`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_member_ssm` (
  `id` BIGINT(20) NOT NULL,
  `filter_type` VARCHAR(40) NOT NULL,
  `multicast_sourcegroup_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_member_ssm_parent` (`id` ASC),
  INDEX `fk_multicast_member_ssm_sourcegroup` (`multicast_sourcegroup_id` ASC),
  CONSTRAINT `fk_multicast_member_ssm_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_member` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_member_ssm_sourcegroup`
    FOREIGN KEY (`multicast_sourcegroup_id`)
    REFERENCES `multicast_sourcegroup` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_source`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_source` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `multicast_sourcegroup_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_source_sourcegroup` (`multicast_sourcegroup_id` ASC),
  CONSTRAINT `fk_multicast_source_sourcegroup`
    FOREIGN KEY (`multicast_sourcegroup_id`)
    REFERENCES `multicast_sourcegroup` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_source_port`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_source_port` (
  `id` BIGINT(20) NOT NULL,
  `port_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_source_port_parent` (`id` ASC),
  INDEX `fk_multicast_source_port_port` (`port_id` ASC),
  CONSTRAINT `fk_multicast_source_port_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_source` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_source_port_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_source_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_source_ipv4` (
  `id` BIGINT(20) NOT NULL,
  `ipv4_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_source_ipv4_parent` (`id` ASC),
  INDEX `fk_multicast_source_ipv4_ipv4address` (`ipv4_address_id` ASC),
  CONSTRAINT `fk_multicast_source_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_source` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_source_ipv4_ipv4address`
    FOREIGN KEY (`ipv4_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `multicast_source_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `multicast_source_ipv6` (
  `id` BIGINT(20) NOT NULL,
  `ipv6_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_multicast_source_ipv6_parent` (`id` ASC),
  INDEX `fk_multicast_source_ipv6_ipv6address` (`ipv6_address_id` ASC),
  CONSTRAINT `fk_multicast_source_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `multicast_source` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_multicast_source_ipv6_ipv6address`
    FOREIGN KEY (`ipv6_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_nat_mapping_port`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_nat_mapping_port` (
  `id` BIGINT(20) NOT NULL,
  `nat_mapping_port_id` BIGINT(20) NULL,
  INDEX `fk_event_nat_mapping_port_parent` (`id` ASC),
  PRIMARY KEY (`id`),
  INDEX `fk_event_nat_mapping_port_content` (`nat_mapping_port_id` ASC),
  CONSTRAINT `fk_event_nat_mapping_port_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_nat_mapping_port_content`
    FOREIGN KEY (`nat_mapping_port_id`)
    REFERENCES `nat_mapping_port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `address_resolution_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `address_resolution_ipv4` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `ipv4_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_address_resolution_ipv4_parent` (`id` ASC),
  INDEX `fk_address_resolution_ipv4_ipv4address` (`ipv4_address_id` ASC),
  CONSTRAINT `fk_address_resolution_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `address_resolution` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_address_resolution_ipv4_ipv4address`
    FOREIGN KEY (`ipv4_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `address_resolution_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `address_resolution_ipv6` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `ipv6_address_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_address_resolution_ipv6_parent` (`id` ASC),
  INDEX `fk_address_resolution_ipv6_ipv6address` (`ipv6_address_id` ASC),
  CONSTRAINT `fk_address_resolution_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `address_resolution` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_address_resolution_ipv6_ipv6address`
    FOREIGN KEY (`ipv6_address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_address_resolution_ipv4`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_address_resolution_ipv4` (
  `id` BIGINT(20) NOT NULL,
  `address_resolution_ipv4_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_address_resolution_ipv4_parent` (`id` ASC),
  INDEX `fk_event_address_resolution_ipv4_content` (`address_resolution_ipv4_id` ASC),
  CONSTRAINT `fk_event_address_resolution_ipv4_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_address_resolution_ipv4_content`
    FOREIGN KEY (`address_resolution_ipv4_id`)
    REFERENCES `address_resolution_ipv4` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_address_resolution_ipv6`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_address_resolution_ipv6` (
  `id` BIGINT(20) NOT NULL,
  `address_resolution_ipv6_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_address_resolution_ipv6_parent` (`id` ASC),
  INDEX `fk_event_address_resolution_ipv6_content` (`address_resolution_ipv6_id` ASC),
  CONSTRAINT `fk_event_address_resolution_ipv6_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_address_resolution_ipv6_content`
    FOREIGN KEY (`address_resolution_ipv6_id`)
    REFERENCES `address_resolution_ipv6` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer25_vlan`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer25_vlan` (
  `id` BIGINT(20) NOT NULL,
  `vlan_configuration_id` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer25_vlan_parent` (`id` ASC),
  INDEX `fk_layer25_vlan_config` (`vlan_configuration_id` ASC),
  CONSTRAINT `fk_layer25_vlan_parent`
    FOREIGN KEY (`id`)
    REFERENCES `layer25` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer25_vlan_config`
    FOREIGN KEY (`vlan_configuration_id`)
    REFERENCES `layer25_vlan_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_configuration_static_address_ref`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_configuration_static_address_ref` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `static_configuration_id` BIGINT(20) NOT NULL,
  `address_id` BIGINT(20) NOT NULL,
  `prefix_length` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_configuration_fixed_address_ref_config` (`static_configuration_id` ASC),
  INDEX `fk_layer3_ipv6_configuration_fixed_address_ref_address` (`address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_configuration_fixed_address_ref_config`
    FOREIGN KEY (`static_configuration_id`)
    REFERENCES `layer3_ipv6_configuration_static` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_configuration_fixed_address_ref_address`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_configuration_static_gateway_ref`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_configuration_static_gateway_ref` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `static_configuration_id` BIGINT(20) NOT NULL,
  `address_id` BIGINT(20) NOT NULL,
  `prefix_length` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_configuration_fixed_gateway_ref_config` (`static_configuration_id` ASC),
  INDEX `fk_layer3_ipv6_configuration_fixed_gateway_ref_address` (`address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_configuration_fixed_gateway_ref_config`
    FOREIGN KEY (`static_configuration_id`)
    REFERENCES `layer3_ipv6_configuration_static` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_configuration_fixed_gateway_ref_address`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv4_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv4_session` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `layer3_ipv4_id` BIGINT(20) NOT NULL,
  `address_id` BIGINT(20) NULL,
  `gateway_address_id` BIGINT(20) NULL,
  `netmask_value` INT(10) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv4_session_protocol` (`layer3_ipv4_id` ASC),
  INDEX `fk_layer3_ipv4_session_ipaddress` (`address_id` ASC),
  INDEX `fk_layer3_ipv4_session_gwaddress` (`gateway_address_id` ASC),
  CONSTRAINT `fk_layer3_ipv4_session_protocol`
    FOREIGN KEY (`layer3_ipv4_id`)
    REFERENCES `layer3_ipv4` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_session_ipaddress`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv4_session_gwaddress`
    FOREIGN KEY (`gateway_address_id`)
    REFERENCES `ipv4_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `layer3_ipv6_session_gateway`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `layer3_ipv6_session_gateway` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `session_id` BIGINT(20) NOT NULL,
  `address_id` BIGINT(20) NOT NULL,
  `type` VARCHAR(40) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_layer3_ipv6_session_gateway_session` (`session_id` ASC),
  INDEX `fk_layer3_ipv6_session_gateway_address` (`address_id` ASC),
  CONSTRAINT `fk_layer3_ipv6_session_gateway_session`
    FOREIGN KEY (`session_id`)
    REFERENCES `layer3_ipv6_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_layer3_ipv6_session_gateway_address`
    FOREIGN KEY (`address_id`)
    REFERENCES `ipv6_address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_layer3_ipv4_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_layer3_ipv4_session` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `ipv4_session_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_layer3_ipv4_session_parent` (`id` ASC),
  INDEX `fk_event_layer3_ipv4_session_content` (`ipv4_session_id` ASC),
  CONSTRAINT `fk_event_layer3_ipv4_session_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_layer3_ipv4_session_content`
    FOREIGN KEY (`ipv4_session_id`)
    REFERENCES `layer3_ipv4_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_layer3_ipv6_session`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_layer3_ipv6_session` (
  `id` BIGINT(20) NOT NULL,
  `ipv6_session_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_layer3_ipv6_session_parent` (`id` ASC),
  INDEX `fk_event_layer3_ipv6_session_content` (`ipv6_session_id` ASC),
  CONSTRAINT `fk_event_layer3_ipv6_session_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_layer3_ipv6_session_content`
    FOREIGN KEY (`ipv6_session_id`)
    REFERENCES `layer3_ipv6_session` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_latency_distribution`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_latency_distribution` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `latency_id` BIGINT(20) NOT NULL,
  `latency_range_minimum` BIGINT(20) NOT NULL,
  `latency_range_maximum` BIGINT(20) NOT NULL,
  `bucket_count` INT(10) NOT NULL,
  `bucket_width` BIGINT(20) NOT NULL,
  `packet_count_below_minimum` BIGINT(20) NOT NULL,
  `packet_count_above_maximum` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_latency_distribution_latency` (`latency_id` ASC),
  CONSTRAINT `fk_fb_latency_distribution_latency`
    FOREIGN KEY (`latency_id`)
    REFERENCES `fb_latency` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_latency_distribution_entry`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_latency_distribution_entry` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `distribution_id` BIGINT(20) NOT NULL,
  `bucket_start_latency` BIGINT(20) NOT NULL,
  `packet_count` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_latency_distribution_entry_owner` (`distribution_id` ASC),
  CONSTRAINT `fk_fb_latency_distribution_entry_owner`
    FOREIGN KEY (`distribution_id`)
    REFERENCES `fb_latency_distribution` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_latency_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_latency_snapshot` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `latency_id` BIGINT(20) NOT NULL,
  `snapshot_time` BIGINT(20) NOT NULL,
  `snapshot_duration` BIGINT(20) NOT NULL,
  `packet_count_valid` BIGINT(20) NOT NULL,
  `packet_count_invalid` BIGINT(20) NOT NULL,
  `latency_minimum` BIGINT(20) NULL,
  `latency_average` BIGINT(20) NULL,
  `latency_maximum` BIGINT(20) NULL,
  `jitter` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_latency_snapshot_owner` (`latency_id` ASC),
  CONSTRAINT `fk_fb_latency_snapshot_owner`
    FOREIGN KEY (`latency_id`)
    REFERENCES `fb_latency` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_outofsequence_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_outofsequence_snapshot` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `outofsequence_id` BIGINT(20) NOT NULL,
  `snapshot_time` BIGINT(20) NOT NULL,
  `snapshot_duration` BIGINT(20) NOT NULL,
  `packet_count_valid` BIGINT(20) NOT NULL,
  `packet_count_outofsequence` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_outofsequence_snapshot_owner` (`outofsequence_id` ASC),
  CONSTRAINT `fk_fb_outofsequence_snapshot_owner`
    FOREIGN KEY (`outofsequence_id`)
    REFERENCES `fb_outofsequence` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_flow_instance`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_flow_instance` (
  `id` BIGINT(20) NOT NULL,
  `flow_instance_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_flow_instance_parent` (`id` ASC),
  INDEX `fk_event_flow_instance_content` (`flow_instance_id` ASC),
  CONSTRAINT `fk_event_flow_instance_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_flow_instance_content`
    FOREIGN KEY (`flow_instance_id`)
    REFERENCES `flow_instance` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_flow_template_frame`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_flow_template_frame` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `flow_template_id` BIGINT(20) NOT NULL,
  `frame_id` BIGINT(20) NOT NULL,
  `position` INT(10) NOT NULL,
  `repeat_count` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_flow_template_frame_flowtemplate` (`flow_template_id` ASC),
  INDEX `fk_fb_flow_template_frame_frame` (`frame_id` ASC),
  CONSTRAINT `fk_fb_flow_template_frame_flowtemplate`
    FOREIGN KEY (`flow_template_id`)
    REFERENCES `fb_flow_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_fb_flow_template_frame_frame`
    FOREIGN KEY (`frame_id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `event_port`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `event_port` (
  `id` BIGINT(20) NOT NULL,
  `port_id` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_event_port_parent` (`id` ASC),
  INDEX `fk_event_port_content` (`port_id` ASC),
  CONSTRAINT `fk_event_port_parent`
    FOREIGN KEY (`id`)
    REFERENCES `event` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_port_content`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_sizefixed`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_sizefixed` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `size` INT(10) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fb_frame_sizefixed_parent` (`id` ASC),
  CONSTRAINT `fk_fb_frame_sizefixed_parent`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_cumulative_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_cumulative_snapshot` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_id_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_id`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_syn_sent`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_syn_sent` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `time_last_syn_sent` BIGINT NOT NULL,
  `count_syn_sent` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_syn_sent_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_syn_received`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_syn_received` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `time_last_syn_received` BIGINT NOT NULL,
  `count_syn_received` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_syn_rx_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref0`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_fin_received`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_fin_received` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `time_last_fin_received` BIGINT NOT NULL,
  `count_fin_received` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_fin_received_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref1`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_fin_sent`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_fin_sent` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `time_last_fin_sent` BIGINT NOT NULL,
  `count_fin_sent` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_ref_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref10`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_estasblished`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_estasblished` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `time_established` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_etablished_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref2`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_rx_counters`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_rx_counters` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `rx_count_header` BIGINT NOT NULL,
  `rx_count_payload` BIGINT NOT NULL,
  `rx_count_total` BIGINT NOT NULL,
  `rx_segment_count` BIGINT NOT NULL,
  `rx_timestamp_last` BIGINT NOT NULL,
  `rx_segments_out_of_order` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_rx_count` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref20`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_tx_counters`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_tx_counters` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `tx_count_header` BIGINT NOT NULL,
  `tx_count_payload` BIGINT NOT NULL,
  `tx_count_total` BIGINT NOT NULL,
  `tx_segment_count` BIGINT NOT NULL,
  `tx_timestamp_last` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_tx_counters_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref200`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcp_session_snapshot_retransmission_counters`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_snapshot_retransmission_counters` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `snapshot_id` BIGINT NOT NULL,
  `retransmission_count_slow` BIGINT NOT NULL,
  `retransmission_count_fast` BIGINT NOT NULL,
  `retransmission_count_total` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `snapshot_retrans_idx` (`snapshot_id` ASC),
  CONSTRAINT `snapshot_ref2000`
    FOREIGN KEY (`snapshot_id`)
    REFERENCES `tcp_session_snapshot` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_fieldmodifier_random`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_fieldmodifier_random` (
  `id` BIGINT(20) NOT NULL,
  `offset` INT NOT NULL,
  `byte_count` INT NOT NULL,
  `minimum` BIGINT NOT NULL,
  `maximum` BIGINT NOT NULL,
  INDEX `fk_fb_frame_fieldmodifier_random_fb_frame1_idx` (`id` ASC),
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_fb_frame_fieldmodifier_random_id`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_fieldmodifier_incremental`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_fieldmodifier_incremental` (
  `id` BIGINT(20) NOT NULL,
  `offset` INT NOT NULL,
  `byte_count` INT NOT NULL,
  `minimum` BIGINT NOT NULL,
  `maximum` BIGINT NOT NULL,
  `initial` BIGINT NOT NULL,
  `step` BIGINT NOT NULL,
  INDEX `fk_fb_frame_fieldmodifier_incremental_fb_frame1_idx` (`id` ASC),
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_fb_frame_fieldmodifier_incremental_fb_frame1`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `fb_frame_fieldmodifier_unique`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `fb_frame_fieldmodifier_unique` (
  `id` BIGINT(20) NOT NULL,
  `offset` INT NOT NULL,
  `byte_count` INT NOT NULL,
  `orig_value` BIGINT NOT NULL,
  `final_value` BIGINT NOT NULL,
  INDEX `fk_fb_frame_fieldmodifier_unique_fb_frame1_idx` (`id` ASC),
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_fb_frame_fieldmodifier_unique_fb_frame1`
    FOREIGN KEY (`id`)
    REFERENCES `fb_frame` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tag`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tag` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NOT NULL,
  PRIMARY KEY (`id`));


-- -----------------------------------------------------
-- Table `postprocessing_engine`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `postprocessing_engine` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(45) NOT NULL,
  `version` VARCHAR(45) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `throughput_flow_test`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `throughput_flow_test` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `fb_flow_template_id` BIGINT NOT NULL,
  `name` VARCHAR(1024) NOT NULL,
  `iteration_size` BIGINT NOT NULL,
  `source_id` BIGINT NOT NULL,
  `destination_id` BIGINT NOT NULL,
  `duration` BIGINT NOT NULL,
  `acceptable_loss` DOUBLE NOT NULL,
  `resolution` DOUBLE NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fb_flow_template_template_throughput_idx` (`fb_flow_template_id` ASC),
  INDEX `fk_throughput_flow_test_source` (`source_id` ASC),
  CONSTRAINT `fb_flow_template_template_throughput`
    FOREIGN KEY (`fb_flow_template_id`)
    REFERENCES `fb_flow_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_throughput_flow_test_source`
    FOREIGN KEY (`source_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_throughput_flow_test_destination`
    FOREIGN KEY (`source_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `throughput_flow_result`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `throughput_flow_result` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `throughput_flow_test` BIGINT NOT NULL,
  `frame_interval` BIGINT NOT NULL,
  `tx_byte_count` BIGINT NOT NULL,
  `rx_byte_count` BIGINT NOT NULL,
  `configured_tx_byte_count` BIGINT NOT NULL,
  `tx_packets` BIGINT NOT NULL,
  `rx_packets` BIGINT NOT NULL,
  `rx_duration` BIGINT NOT NULL,
  `acceptable_loss` DOUBLE NOT NULL,
  `resolution` DOUBLE NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_throughput_flow_result_flow_test_idx` (`throughput_flow_test` ASC),
  CONSTRAINT `fk_throughput_flow_result_flow_test`
    FOREIGN KEY (`throughput_flow_test`)
    REFERENCES `throughput_flow_test` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `port_group`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `port_group` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(21844) NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `name_UNIQUE` (`name` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `port_group_members`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `port_group_members` (
  `members_id` BIGINT NOT NULL AUTO_INCREMENT,
  `port_group_id` BIGINT NOT NULL,
  `port_id` BIGINT NOT NULL,
  PRIMARY KEY (`members_id`),
  INDEX `fk_port_group_members_1_idx` (`port_id` ASC),
  INDEX `fk_port_group_members_group_idx` (`port_group_id` ASC),
  CONSTRAINT `fk_port_group_members_port`
    FOREIGN KEY (`port_id`)
    REFERENCES `port` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_port_group_members_group`
    FOREIGN KEY (`port_group_id`)
    REFERENCES `port_group` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

CREATE TABLE IF NOT EXISTS `file_store` (
	`name` varchar(255),
	`description` varchar(255),
	`data` blob
);

-- -----------------------------------------------------
-- Placeholder table for view `ipv6_address_hex`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `ipv6_address_hex` (`id` INT, `address_hex` INT);

-- -----------------------------------------------------
-- Placeholder table for view `ipv4_address_hex`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `ipv4_address_hex` (`id` INT, `address_hex` INT);

-- -----------------------------------------------------
-- Placeholder table for view `mac_address_hex`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mac_address_hex` (`id` INT, `address_hex` INT);

-- -----------------------------------------------------
-- Placeholder table for view `tcp_session_interval_snapshot`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `tcp_session_interval_snapshot` (`id` INT, `snapshot_id` INT);

CREATE TABLE IF NOT EXISTS  `wifi_samples` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`snapshot_time` BIGINT(20) NOT NULL,
	`rssi` INT NOT NULL,
	`bssid` VARCHAR(40),
	`ssid` VARCHAR(40),
	`net_interface` VARCHAR(128),
	`port_name` VARCHAR(40)
);

-- -----------------------------------------------------
-- View `ipv6_address_hex`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `ipv6_address_hex`;
CREATE  OR REPLACE VIEW `ipv6_address_hex` AS
  SELECT id, HEX(address) as address_hex
  FROM `ipv6_address`;

-- -----------------------------------------------------
-- View `ipv4_address_hex`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `ipv4_address_hex`;
CREATE  OR REPLACE VIEW `ipv4_address_hex` AS
  SELECT id, HEX(address) as address_hex
  FROM `ipv4_address`;

-- -----------------------------------------------------
-- View `mac_address_hex`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `mac_address_hex`;
CREATE  OR REPLACE VIEW `mac_address_hex` AS
  SELECT id, HEX(address) as address_hex
  FROM `mac_address`;

-- -----------------------------------------------------
-- View `tcp_session_interval_snapshot`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `tcp_session_interval_snapshot`;
CREATE  OR REPLACE VIEW `tcp_session_interval_snapshot` AS
SELECT snapshot.id as id, snapshot.id as snapshot_id
  FROM `tcp_session_snapshot` snapshot LEFT OUTER JOIN `tcp_session_cumulative_snapshot` cumul on snapshot.id = cumul.snapshot_id
  WHERE cumul.id IS NULL;
