/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.Frame;
import com.excentis.products.byteblower.communication.api.FrameFieldModifierIncremental;
import com.excentis.products.byteblower.communication.api.FrameFieldModifierRandom;
import com.excentis.products.byteblower.communication.api.FrameTagTx;
import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.IncrementalFieldModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomFieldModifier;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.UniqueFieldModifier;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.ConfigureMobileRx;
import com.excentis.products.byteblower.run.actions.ConfigureMobileTx;
import com.excentis.products.byteblower.run.actions.CreateFrames;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.VerifyMobileFBFlow;
import com.excentis.products.byteblower.run.actions.VerifyMobileFrame;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeGrowingSizeModifier;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyBasic;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyDistribution;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimeMultipleBurstModifier;
import com.excentis.products.byteblower.run.objects.RuntimeOutOfSequence;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRandomSizeModifier;
import com.excentis.products.byteblower.utils.Pair;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.UniqueEList;

public final class ConfigureFlowTrafficFb
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private final RuntimeFbFlow rtFbFlow;
    private final FrameBlastingFlowReader mFbFlowTemplateReader;
    private final FlowMeasurementReader mFlowInstanceReader;

    public static AbstractAction create(Context context, RuntimeFbFlow rtFbFlow) {
        return context.decorate(new ConfigureFlowTrafficFb(context, rtFbFlow));
    }

    private ConfigureFlowTrafficFb(Context context, RuntimeFbFlow rtFbFlow) {
        super(context, Listener.class);
        this.rtFbFlow = rtFbFlow;
        this.mFlowInstanceReader = rtFbFlow.getModelFlowInstanceReader();
        this.mFbFlowTemplateReader = rtFbFlow.getModelFbFlowTemplateReader();
    }

    @Override
    public String getDescription() {
        return "Configure traffic for flow '" + this.rtFbFlow.name() + "' (frame blasting)";
    }

    @Override
    public void invokeImpl() {
        RuntimePort source = this.rtFbFlow.getSourceRuntimePort();
        if (source.isMobile()) {
            this.configureMobileFrames();
            this.configureMobileTx();
            this.configureRx();
            ((Listener)this.getListener()).onFbFlowTrafficConfigured(this.rtFbFlow);
            return;
        }
        CreateFrames.create(this.getContext(), (UniqueEList<FrameReader>)this.mFbFlowTemplateReader.getUniqueFrames(), this.rtFbFlow).invoke();
        this.configureTx();
        this.configureRx();
        ((Listener)this.getListener()).onFbFlowTrafficConfigured(this.rtFbFlow);
    }

    private void configureMobileTx() {
        VerifyMobileFBFlow.create(this.getContext(), this.rtFbFlow, (RuntimeMobileDevice)this.rtFbFlow.getSourceRuntimePort()).invoke();
        this.rtFbFlow.addMobileConfig(ConfigureMobileTx.create(this.getContext(), this.rtFbFlow));
    }

    private void configureMobileFrames() {
        boolean hasListeners = this.rtFbFlow.getDestinationAndEavesdropperRuntimePortsConfigured().size() > 0;
        boolean needsNatDiscovery = this.rtFbFlow.getRuntimeFlowSource().isNatted() && hasListeners;
        Context context = this.getContext();
        for (FrameReader mFbFrameReader : this.mFbFlowTemplateReader.getUniqueFrames()) {
            RuntimeFrameTx rtFrame = new RuntimeFrameTx(this.rtFbFlow, (com.excentis.products.byteblower.model.Frame)mFbFrameReader.getObject());
            VerifyMobileFrame.create(context, this.rtFbFlow, rtFrame).invoke();
            if (needsNatDiscovery) {
                FrameResolver resolver = new FrameResolver(rtFrame);
                this.getContext().listen(NatDiscovery.Listener.class, resolver);
                NatDiscovery.create(context, rtFrame, NatDiscovery.EndPointType.SOURCE).invoke();
                this.getContext().unlisten(NatDiscovery.Listener.class, resolver);
            }
            rtFrame.applyDynamicUdpConfiguration();
            this.applyFrameFieldModifiers(rtFrame, null, new ArrayList<Pair<Integer, Integer>>());
            this.rtFbFlow.addRuntimeFrameTx(rtFrame);
            this.rtFbFlow.getRuntimeFlowSource().getRuntimePort().addTxFrame(rtFrame);
        }
    }

    private void configureTx() {
        FrameModifier mFrameModifier;
        RuntimePort rtSourcePort = this.rtFbFlow.getSourceRuntimePort();
        Stream apiStream = rtSourcePort.getApiPort().TxStreamAdd();
        for (RuntimeFrameTx txFrame : rtSourcePort.getOutgoingFrames()) {
            if (txFrame.getRuntimeFlow() != this.rtFbFlow) continue;
            this.rtFbFlow.addRuntimeFrameTx(txFrame);
        }
        Long startTime = this.mFlowInstanceReader.getStartTimeInNanoseconds();
        if (startTime == null) {
            throw new IllegalStateException("Each flow instance should have valid start time");
        }
        apiStream.InitialTimeToWaitSet(startTime.longValue());
        Long numberOfFrames = this.mFlowInstanceReader.getNumberOfFrames();
        if (numberOfFrames == null) {
            throw new IllegalStateException("Each FB flow instance should have valid number of frames");
        }
        apiStream.NumberOfFramesSet(numberOfFrames / (long)this.rtFbFlow.getDivisor());
        Long interFrameGap = this.mFbFlowTemplateReader.getFrameIntervalInNanoseconds();
        apiStream.InterFrameGapSet(interFrameGap * (long)this.rtFbFlow.getDivisor());
        for (FrameReader mTxFrameReader : this.mFbFlowTemplateReader.getRepeatedFrameReaders()) {
            RuntimeFrameTx rtFrame = this.rtFbFlow.getRuntimeFrameTx(mTxFrameReader);
            if (rtFrame == null) {
                throw new IllegalStateException("Runtime frames should exist when adding TX frames to the FB flow");
            }
            this.addTxFrameToStream(apiStream, rtFrame);
        }
        this.rtFbFlow.setApiStream(apiStream);
        TimingModifier mTimingModifier = this.mFbFlowTemplateReader.getTimingModifier();
        if (mTimingModifier != null) {
            if (mTimingModifier instanceof MultipleBurst) {
                this.rtFbFlow.setRuntimeTimingModifier(new RuntimeMultipleBurstModifier(this.rtFbFlow, (MultipleBurst)mTimingModifier));
            } else {
                throw new IllegalStateException("Unsupported timing modifier type " + mTimingModifier.getClass().getSimpleName());
            }
        }
        if ((mFrameModifier = this.mFbFlowTemplateReader.getFrameModifier()) != null) {
            if (mFrameModifier instanceof GrowingSizeModifier) {
                this.rtFbFlow.setRuntimeFrameModifier(new RuntimeGrowingSizeModifier(this.rtFbFlow, (GrowingSizeModifier)mFrameModifier));
            } else if (mFrameModifier instanceof RandomSizeModifier) {
                this.rtFbFlow.setRuntimeFrameModifier(new RuntimeRandomSizeModifier(this.rtFbFlow, (RandomSizeModifier)mFrameModifier));
            } else {
                throw new IllegalStateException("Unsupported frame modifier type " + mFrameModifier.getClass().getSimpleName());
            }
        }
    }

    private RuntimeFrameTx addTxFrameToStream(Stream apiStream, RuntimeFrameTx rtFrameTx) {
        com.excentis.products.byteblower.model.Frame mFbFrameOriginal = rtFrameTx.getModelFbFrame();
        Frame apiTxFrame = this.createApiFrame(apiStream, rtFrameTx);
        ArrayList<Pair<Integer, Integer>> forbiddenRegions = new ArrayList<Pair<Integer, Integer>>();
        int frameSize = rtFrameTx.getFrameLength();
        boolean zeroedUDPChecksum = false;
        this.applyFrameFieldModifiers(rtFrameTx, apiTxFrame, forbiddenRegions);
        apiTxFrame.BytesSet(rtFrameTx.getByteHexString());
        if (this.rtFbFlow.hasOutOfSequenceDetection()) {
            FrameTagTx apiTxSequenceTag = apiTxFrame.FrameTagSequenceGet();
            apiTxSequenceTag.Enable(true);
            this.findPosition(apiTxSequenceTag, forbiddenRegions, frameSize);
        }
        if (this.rtFbFlow.hasLatencyMeasurement()) {
            FrameTagTx apiTxTimeTag = apiTxFrame.FrameTagTimeGet();
            apiTxTimeTag.Enable(true);
            this.findPosition(apiTxTimeTag, forbiddenRegions, frameSize);
        }
        apiTxFrame.SetL3AutoChecksum(mFbFrameOriginal.getL3AutoHeaderCheck().booleanValue());
        apiTxFrame.SetL3AutoLength(mFbFrameOriginal.getL3AutoTotLen().booleanValue());
        if (mFbFrameOriginal.getL4AutoUdpChecksum().booleanValue()) {
            if (rtFrameTx.hasUDPHeader() && zeroedUDPChecksum) {
                rtFrameTx.clearUDPChecksum();
            } else if (rtFrameTx.hasUDPHeader()) {
                apiTxFrame.SetL4AutoChecksum(true);
            } else if (rtFrameTx.hasTCPHeader()) {
                apiTxFrame.SetL4AutoChecksum(mFbFrameOriginal.getL4AutoTcpChecksum().booleanValue());
            }
        }
        apiTxFrame.SetL4AutoLength(mFbFrameOriginal.getL4AutoTotLen().booleanValue());
        return rtFrameTx;
    }

    private void applyFrameFieldModifiers(RuntimeFrameTx rtFrameTx, Frame apiTxFrame, ArrayList<Pair<Integer, Integer>> forbiddenRegion) {
        com.excentis.products.byteblower.model.Frame mFbFrameOriginal = rtFrameTx.getModelFbFrame();
        for (FrameModifier modifier : mFbFrameOriginal.getModifiers()) {
            int start;
            RandomFieldModifier mod;
            if (rtFrameTx.getHighestProtocol() != BPFFilter.Proto.UDP) {
                LOGGER.warning("Frame Modifiers are solely supported for UDP");
                break;
            }
            RuntimePort srcPort = rtFrameTx.getRuntimeFlow().getSourceRuntimePort();
            int UDPOffset = srcPort.getLayer25OverheadSize() + rtFrameTx.getProtocolOffset(BPFFilter.Proto.UDP) + BPFFilter.Proto.UDP.headerByteSize();
            if (modifier instanceof RandomFieldModifier && apiTxFrame != null) {
                mod = (RandomFieldModifier)modifier;
                FrameFieldModifierRandom g = apiTxFrame.ModifierFieldRandomAdd();
                start = mod.getOffset() + UDPOffset;
                g.OffsetSet(start);
                g.LengthSet(mod.getFieldLength());
                forbiddenRegion.add((Pair<Integer, Integer>)new Pair((Object)start, (Object)(start + mod.getFieldLength())));
                int bitSize = 8 * mod.getFieldLength();
                g.MinimumSet(Long.MIN_VALUE >> 64 - bitSize);
                g.MaximumSet(Long.MAX_VALUE >> 64 - bitSize);
                continue;
            }
            if (modifier instanceof IncrementalFieldModifier && apiTxFrame != null) {
                mod = (IncrementalFieldModifier)modifier;
                int bitSize = 8 * mod.getFieldLength();
                FrameFieldModifierIncremental g = apiTxFrame.ModifierFieldIncrementalAdd();
                int start2 = mod.getOffset() + UDPOffset;
                g.OffsetSet(mod.getOffset() + UDPOffset);
                g.LengthSet(mod.getFieldLength());
                forbiddenRegion.add((Pair<Integer, Integer>)new Pair((Object)start2, (Object)(start2 + mod.getFieldLength())));
                g.MinimumSet(Long.MIN_VALUE >> 64 - bitSize);
                g.MaximumSet(Long.MAX_VALUE >> 64 - bitSize);
                g.StepSet(mod.getStepSize());
                g.InitialValueSet(0L);
                continue;
            }
            if (!(modifier instanceof UniqueFieldModifier)) continue;
            mod = (UniqueFieldModifier)modifier;
            int bitSize = 8 * mod.getFieldLength();
            start = UDPOffset + mod.getOffset();
            byte[] payload = rtFrameTx.getUPDPayload();
            forbiddenRegion.add((Pair<Integer, Integer>)new Pair((Object)start, (Object)(start + mod.getFieldLength())));
            if (mod.getOffset() >= payload.length) continue;
            bitSize = Math.min(bitSize, (payload.length - mod.getOffset()) * 8);
            byte[] memRepresentation = this.makeUniqueBytes(bitSize);
            int ctr = 0;
            while (ctr < memRepresentation.length) {
                payload[ctr + mod.getOffset()] = memRepresentation[ctr];
                ++ctr;
            }
            rtFrameTx.setUDPPayload(payload);
        }
    }

    private byte[] makeUniqueBytes(int bitSize) {
        int nBytes = bitSize / 8;
        long LENGTHMASK = bitSize < 64 ? (1L << bitSize) - 1L : -1L;
        long value = RuntimeFbFlow.getUnique() & LENGTHMASK;
        byte[] memRepresentation = new byte[nBytes];
        int ctr = nBytes - 1;
        while (ctr >= 0) {
            byte byteValue;
            memRepresentation[nBytes - 1 - ctr] = byteValue = (byte)(value >> 8 * ctr & 0xFFL);
            --ctr;
        }
        return memRepresentation;
    }

    private Frame createApiFrame(Stream apiStream, RuntimeFrameTx rtFrameTx) {
        Frame apiTxFrame = apiStream.FrameAdd();
        String initalHexString = rtFrameTx.getByteHexString();
        apiTxFrame.BytesSet(initalHexString);
        return apiTxFrame;
    }

    private void findPosition(FrameTagTx apiTxSequenceTag, ArrayList<Pair<Integer, Integer>> forbiddenRegion, int frameSize) {
        boolean blocked;
        int length = (int)apiTxSequenceTag.MetricsGet().LengthGet();
        int alignment = (int)apiTxSequenceTag.MetricsGet().AlignmentGet();
        int startPosition = frameSize - length;
        do {
            blocked = false;
            for (Pair<Integer, Integer> blocker : forbiddenRegion) {
                boolean bl = blocked = blocked || (Integer)blocker.getFirst() < startPosition + length && (Integer)blocker.getSecond() > startPosition;
            }
            if (!blocked) continue;
            startPosition -= alignment;
        } while (blocked);
        forbiddenRegion.add((Pair<Integer, Integer>)new Pair((Object)startPosition, (Object)(startPosition + length)));
        apiTxSequenceTag.PositionSet((long)(frameSize - startPosition));
    }

    private void configureRx() {
        for (RuntimePort rtPort : this.rtFbFlow.getDestinationAndEavesdropperRuntimePortsConfigured()) {
            if (rtPort.isMobile()) {
                this.configureMobileRx((RuntimeMobileDevice)rtPort, this.rtFbFlow);
                continue;
            }
            this.configureBBRx(rtPort, this.rtFbFlow);
        }
    }

    private void configureBBRx(RuntimePort rtPort, RuntimeFbFlow flow) {
        if (flow.hasLatencyDistributionMeasurement()) {
            ByteBlowerProjectReader mProjectReader = ReaderFactory.create((ByteBlowerProject)flow.getRuntimeScenario().getModelScenario().getByteBlowerProject());
            flow.addRuntimeReceiver(new RuntimeLatencyDistribution(flow, rtPort, mProjectReader.getLatencyDistributionRangeStartNs(), mProjectReader.getLatencyDistributionRangeEndNs()));
        }
        if (flow.hasLatencyMeasurement()) {
            flow.addRuntimeReceiver(new RuntimeLatencyBasic(flow, rtPort));
        }
        if (flow.hasOutOfSequenceDetection()) {
            flow.addRuntimeReceiver(new RuntimeOutOfSequence(flow, rtPort));
        }
        flow.isRuntimeFrameModifierConfigured();
        flow.addRuntimeReceiver(rtPort.createBasicTrigger(flow));
    }

    private void configureMobileRx(RuntimeMobileDevice rtPort, RuntimeFbFlow flow) {
        if (flow.hasLatencyDistributionMeasurement()) {
            flow.addMobileConfig(ConfigureMobileRx.createLatency(this.getContext(), flow, rtPort));
            flow.addMobileConfig(ConfigureMobileRx.createDistribution(this.getContext(), flow, rtPort));
        } else if (flow.hasLatencyMeasurement()) {
            flow.addMobileConfig(ConfigureMobileRx.createLatency(this.getContext(), flow, rtPort));
        } else {
            flow.addMobileConfig(ConfigureMobileRx.createRx(this.getContext(), flow, rtPort));
        }
        VerifyMobileFBFlow.create(this.getContext(), flow, rtPort).invoke();
    }

    private static class FrameResolver
    implements NatDiscovery.Listener {
        private final RuntimeFrameTx rtFrame;

        private FrameResolver(RuntimeFrameTx rtFrame) {
            this.rtFrame = rtFrame;
        }

        @Override
        public void onNatPortDiscoveryFailed(RuntimePort resolver, RuntimePort target, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, String errorMessage) {
        }

        @Override
        public void onNatPortDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.rtFrame.setPublicSourceIpAddress(publicIpv4);
            this.rtFrame.setPublicSourceL4Port(publicL4Port);
        }

        @Override
        public void onNatDiscoveryFailed(RuntimePort resolver, RuntimePort target, String errorMessage) {
        }

        @Override
        public void onNatDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.rtFrame.setPublicDestinationIpAddress(publicIpv4);
        }
    }

    public static interface Listener {
        public void onFbFlowTrafficConfigured(RuntimeFbFlow var1);

        public void onFbFlowLatencyWarning(RuntimeFbFlow var1, RuntimeFrame var2);

        public void onFbFlowConfigurationWarning(RuntimeFbFlow var1, String var2);
    }
}

