/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.IPv4Configuration;
import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.communication.api.Layer3Configuration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.run.actions.PerformDhcp;
import com.excentis.products.byteblower.run.actions.PerformStatelessAutoconfiguration;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ConfigureLayer3
extends ConcreteAction<Listener>
implements PerformDhcp.Listener,
PerformStatelessAutoconfiguration.Listener {
    private final RuntimePort rtPort;
    private final ByteBlowerGuiPortReader mPortReader;

    static AbstractAction create(Context context, RuntimePort rtPort) {
        return context.decorate(new ConfigureLayer3(context, rtPort));
    }

    private ConfigureLayer3(Context context, RuntimePort rtPort) {
        super(context, Listener.class);
        this.rtPort = rtPort;
        this.mPortReader = rtPort.getModelPortReader();
    }

    @Override
    public String getDescription() {
        return "Configure layer 3 of '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        this.getContext().listen(PerformDhcp.Listener.class, this);
        this.getContext().listen(PerformStatelessAutoconfiguration.Listener.class, this);
        if (this.rtPort.getState() == RuntimePort.State.CREATED) {
            ((Listener)this.getListener()).onLayer3Configuring(this.rtPort);
        }
        if (this.mPortReader.isIPv4()) {
            this.configureIPv4();
        } else if (this.mPortReader.isIPv6()) {
            this.configureIPv6();
        } else {
            throw new IllegalStateException("Unknown layer 3 type on model port " + this.mPortReader.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureIPv4() {
        if (this.rtPort.getState() == RuntimePort.State.CREATED) {
            IPv4Configuration apiIpv4 = this.rtPort.getApiPort().Layer3IPv4Set();
            RuntimeLayer3Configuration rtL3Config = this.rtPort.configureRuntimeLayer3Configuration((Layer3Configuration)apiIpv4);
            if (this.mPortReader.usesDHCP()) {
                PerformDhcp.create(this.getContext(), rtL3Config).invoke();
                return;
            } else {
                if (!this.mPortReader.usesFixedIPConfiguration()) throw new IllegalStateException("Unknown IPv4 configuration on model port " + this.mPortReader.getName());
                apiIpv4.IpSet(this.mPortReader.getIPAddress());
                apiIpv4.GatewaySet(this.mPortReader.getDefaultIpv4Gateway());
                apiIpv4.NetmaskSet(this.mPortReader.getNetmask());
                ((Listener)this.getListener()).onLayer3Configured(rtL3Config);
            }
            return;
        } else {
            if (this.rtPort.getState() != RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC || !this.mPortReader.usesDHCP()) return;
            PerformDhcp.create(this.getContext(), this.rtPort.getRuntimeLayer3Configuration()).invoke();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureIPv6() {
        if (this.rtPort.getState() == RuntimePort.State.CREATED) {
            IPv6Configuration apiIpv6 = this.rtPort.getApiPort().Layer3IPv6Set();
            RuntimeLayer3Configuration rtL3Config = this.rtPort.configureRuntimeLayer3Configuration((Layer3Configuration)apiIpv6);
            if (this.mPortReader.usesDHCP()) {
                PerformDhcp.create(this.getContext(), rtL3Config).invoke();
                return;
            } else if (this.mPortReader.usesStatelessAutoconfiguration()) {
                PerformStatelessAutoconfiguration.create(this.getContext(), rtL3Config).invoke();
                return;
            } else {
                if (!this.mPortReader.usesFixedIPConfiguration()) throw new IllegalStateException("Unknown IPv6 configuration on model port " + this.mPortReader.getName());
                apiIpv6.IpManualAdd(String.valueOf(this.mPortReader.getIPAddress()) + "/" + this.mPortReader.getPrefixLengthString());
                apiIpv6.GatewaySet(this.mPortReader.getDefaultIpv6Router());
                ((Listener)this.getListener()).onLayer3Configured(rtL3Config);
            }
            return;
        } else {
            if (this.rtPort.getState() != RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC || !this.mPortReader.usesDHCP()) return;
            PerformDhcp.create(this.getContext(), this.rtPort.getRuntimeLayer3Configuration()).invoke();
        }
    }

    @Override
    public void onDHCPPerformed(RuntimeLayer3Configuration rtL3Config) {
        ((Listener)this.getListener()).onLayer3Configured(rtL3Config);
    }

    @Override
    public void onDHCPPerformFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
    }

    @Override
    public void onStatelessAutoconfigurationPerformed(RuntimeLayer3Configuration rtL3Config) {
        ((Listener)this.getListener()).onLayer3Configured(rtL3Config);
    }

    @Override
    public void onStatelessAutoconfigurationFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
    }

    public static interface Listener {
        public void onLayer3Configuring(RuntimePort var1);

        public void onLayer3Configured(RuntimeLayer3Configuration var1);
    }
}

