/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.actions.ConfigureLayer3;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyError;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimeMobileL3IPv4Configuation;
import com.excentis.products.byteblower.run.objects.RuntimeMobileL3IPv6Configuation;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ConfigureMobileDevice
extends ConcreteAction<ConfigurePort.Listener> {
    private final RuntimeMobileDevice rtPort;

    public static AbstractAction create(Context context, RuntimeMobileDevice rtPort) {
        return context.decorate(new ConfigureMobileDevice(context, rtPort));
    }

    private ConfigureMobileDevice(Context context, RuntimeMobileDevice rtPort) {
        super(context, ConfigurePort.Listener.class);
        this.rtPort = rtPort;
    }

    @Override
    public String getDescription() {
        return "Configure Mobile device '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        try {
            if (this.rtPort.getState() == RuntimePort.State.CREATED) {
                this.rtPort.setState(RuntimePort.State.CONFIGURED);
                ((ConfigurePort.Listener)this.getListener()).onPortConfigured(this.rtPort);
                RuntimeMobileL3IPv4Configuation configIpv4 = new RuntimeMobileL3IPv4Configuation(this.rtPort);
                RuntimeMobileL3IPv6Configuation configIpv6 = new RuntimeMobileL3IPv6Configuation(this.rtPort);
                this.rtPort.setRuntimeLayer3(configIpv4);
                this.getContext().bellman(ConfigureLayer3.Listener.class).onLayer3Configuring(this.rtPort);
                this.getContext().bellman(ConfigureLayer3.Listener.class).onLayer3Configured(configIpv4);
                this.getContext().bellman(ConfigureLayer3.Listener.class).onLayer3Configured(configIpv6);
                return;
            }
        }
        catch (UserFriendlyError ufe) {
            this.rtPort.setState(RuntimePort.State.FAILED);
            ((ConfigurePort.Listener)this.getListener()).onPortConfigurationFailed(this.rtPort, ufe.toString());
            throw ufe;
        }
        catch (RuntimeDomainError rtde) {
            this.rtPort.setState(RuntimePort.State.FAILED);
            ((ConfigurePort.Listener)this.getListener()).onPortConfigurationFailed(this.rtPort, rtde.getMessage());
            throw rtde;
        }
    }
}

