/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerServerType;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.CreatePort;
import com.excentis.products.byteblower.run.actions.CreateServers;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import org.eclipse.emf.common.util.EList;

public final class CreatePorts
extends ConcreteAction<Listener> {
    private final RuntimeScenario rtScenario;
    private final RuntimeByteBlower rtByteBlower;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new CreatePorts(context, rtScenario));
    }

    private CreatePorts(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.rtByteBlower = rtScenario.getRuntimeByteBlower();
    }

    @Override
    public String getDescription() {
        return "Create ports";
    }

    @Override
    public void invokeImpl() {
        CreateServers.create(this.getContext(), this.rtScenario).invoke();
        ScenarioReader scenarioReader = this.rtScenario.getModelScenarioReader();
        EList usedPorts = scenarioReader.getInvolvedPorts();
        for (ByteBlowerGuiPort mPort : usedPorts) {
            this.processPort(mPort);
        }
        if (usedPorts.size() != this.rtScenario.getRuntimePorts().size()) {
            throw new IllegalStateException("Number of used ports should be equal to number of RuntimePorts after CreatePorts action");
        }
        ((Listener)this.getListener()).onPortsCreated(this.rtScenario);
    }

    private void processPort(ByteBlowerGuiPort mPort) {
        if (this.rtScenario.hasRuntimePort(mPort)) {
            return;
        }
        ByteBlowerServerType serverType = mPort.getByteBlowerGuiPortConfiguration().getPhysicalServerType();
        switch (serverType) {
            case BYTE_BLOWER: {
                ByteBlowerGuiPortReader mPortReader = ReaderFactory.create((ByteBlowerGuiPort)mPort);
                RuntimeBBServer rtServer = this.rtByteBlower.findRuntimeBBServerOnURL(mPortReader.getServerAddress());
                if (rtServer == null) {
                    throw new IllegalStateException("RuntimeServer " + mPortReader.getServerAddress() + " should be registered at this point.");
                }
                CreatePort.create(this.getContext(), this.rtScenario, rtServer, mPort).invoke();
                break;
            }
            case MEETING_POINT: {
                ByteBlowerGuiPortReader mPortReader = ReaderFactory.create((ByteBlowerGuiPort)mPort);
                RuntimeMeetingPoint rtServer = this.rtByteBlower.findRuntimeMeetingPointOnURL(mPortReader.getServerAddress());
                if (rtServer == null) {
                    throw new IllegalStateException("RuntimeServer " + mPortReader.getServerAddress() + " should be registered at this point.");
                }
                CreatePort.create(this.getContext(), this.rtScenario, rtServer, mPort).invoke();
                break;
            }
        }
    }

    public static interface Listener {
        public void onPortsCreated(RuntimeScenario var1);
    }
}

