/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerServerIncompatible;
import com.excentis.products.byteblower.communication.api.ByteBlowerServerUnreachable;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CreateServer
extends ConcreteAction<Listener> {
    public static final int WORK = 5;
    private final RuntimeByteBlower rtByteBlower;
    private final String serverUrl;

    static AbstractAction create(Context context, RuntimeByteBlower runtimeByteBlower, String serverUrl) {
        return context.decorate(new CreateServer(context, runtimeByteBlower, serverUrl));
    }

    private CreateServer(Context context, RuntimeByteBlower rtByteBlower, String serverUrl) {
        super(context, Listener.class);
        this.rtByteBlower = rtByteBlower;
        this.serverUrl = serverUrl;
    }

    @Override
    public String getDescription() {
        return "Create server " + this.serverUrl;
    }

    @Override
    public void invokeImpl() {
        try {
            RuntimeBBServer rtServer = this.rtByteBlower.addBBServer(this.serverUrl);
            ((Listener)this.getListener()).onServerCreated(rtServer);
        }
        catch (ByteBlowerServerIncompatible e) {
            ((Listener)this.getListener()).onServerCreationFailed(this.serverUrl, Listener.ErrorType.INCOMPATIBLE_VERSION, e.getMessage());
            throw e;
        }
        catch (ByteBlowerServerUnreachable e) {
            String messageFormat = this.checkReachable() ? "The ByteBlower server ('%s') is reachable, but is the ByteBlower software running?" : "The ByteBlower server ('%s') is not reachable!";
            String message = String.valueOf(String.format(messageFormat, this.serverUrl)) + "\n" + e.getMessage();
            Logger.getGlobal().log(Level.INFO, message);
            ((Listener)this.getListener()).onServerCreationFailed(this.serverUrl, Listener.ErrorType.UNKNOWN_ERROR, message);
            throw e;
        }
    }

    private boolean checkReachable() {
        try {
            InetAddress address = InetAddress.getByName(this.serverUrl);
            return address.isReachable(250);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "Not able to check reachability", e);
            return false;
        }
    }

    public static interface Listener {
        public void onServerCreated(RuntimeBBServer var1);

        public void onServerCreationFailed(String var1, ErrorType var2, String var3);

        public static enum ErrorType {
            INCOMPATIBLE_VERSION,
            UNKNOWN_ERROR;

        }
    }
}

