/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.FrameTagTx;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.IdenticalFramesFound;
import com.excentis.products.byteblower.run.exceptions.IndistinguishableFramesFound;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.utils.Interval;
import com.excentis.products.byteblower.utils.Pair;
import com.excentis.products.byteblower.utils.SubSetIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.map.MultiValueMap;

public final class ImproveFilters
extends ConcreteAction<Listener> {
    private static final int TIME_LIMIT_MS = 5000;
    private static final int MAX_COMPARISON_BYTES = 4;
    private IdentityHashMap<RuntimeFrame, Integer> overwrittenPortionCache = new IdentityHashMap();
    private final RuntimeScenario rtScenario;
    private final List<RuntimeFlow> rtFbFlowsConfigured;

    private ImproveFilters(Context context, RuntimeScenario runtimeScenario) {
        super(context, Listener.class);
        this.rtScenario = runtimeScenario;
        this.rtFbFlowsConfigured = this.rtScenario.getRuntimeFlows();
    }

    static AbstractAction create(Context context, RuntimeScenario runtimeScenario) {
        return context.decorate(new ImproveFilters(context, runtimeScenario));
    }

    @Override
    public String getDescription() {
        return "Improving flow filters";
    }

    private boolean isIgnoreInitializationErrors() {
        return this.rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().isIgnoreInitializationError();
    }

    private void generateExceptions(MultiValueMap identicalFrameMapImproved, MultiValueMap indistinguishableFrameMapImproved) {
        boolean neverWarn;
        boolean bl = neverWarn = this.isIgnoreInitializationErrors() || !this.rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().isIdenticalFramesWarning();
        if (neverWarn) {
            return;
        }
        if (identicalFrameMapImproved.size() > 0) {
            String error = this.composeErrorMessage(identicalFrameMapImproved, "identical");
            throw new IdenticalFramesFound(error);
        }
        if (indistinguishableFrameMapImproved.size() > 0) {
            String error = this.composeErrorMessage(indistinguishableFrameMapImproved, "indistinguishable");
            throw new IndistinguishableFramesFound(error);
        }
    }

    private String composeErrorMessage(MultiValueMap problemFrames, String briefProblem) {
        String error;
        InterfaceFrame firstLhs = (InterfaceFrame)problemFrames.keySet().iterator().next();
        Collection conflictingFrames = problemFrames.getCollection((Object)firstLhs);
        RuntimeFrame sampleConflict = (RuntimeFrame)conflictingFrames.iterator().next();
        RuntimeInterface rtInterface = firstLhs.getBbInterface();
        RuntimeFrameRx firstLhsFrame = firstLhs.getFrame();
        String serverDesc = rtInterface.getRuntimeServer().getIPAddress();
        String interfaceDesc = rtInterface.getCode();
        if (firstLhsFrame.getModelFbFrame().equals(sampleConflict.getModelFbFrame())) {
            String errorFormat = "Frame '%s' of flows '%s' and '%s' arriving on %s of server %s are %s; cannot create unique BPF filter";
            error = String.format(errorFormat, firstLhsFrame.getModelFbFrame().getName(), firstLhsFrame.getRuntimeFlow().name(), sampleConflict.getRuntimeFlow().name(), interfaceDesc, serverDesc, briefProblem);
        } else {
            String errorFormat = "Frames '%s' of flow '%s' and '%s' of flow '%s' arriving on '%s' of server '%s' are %s; cannot create unique BPF filter";
            error = String.format(errorFormat, firstLhsFrame.getModelFbFrame().getName(), firstLhsFrame.getRuntimeFlow().name(), sampleConflict.getModelFbFrame().getName(), sampleConflict.getRuntimeFlow().name(), interfaceDesc, serverDesc, briefProblem);
        }
        return error;
    }

    @Override
    public void invokeImpl() {
        Pair<MultiValueMap, MultiValueMap> frameMaps = this.fillCollidingFrameMaps2();
        MultiValueMap identicalFrameMap = (MultiValueMap)frameMaps.getFirst();
        MultiValueMap indistinguishableFrameMap = (MultiValueMap)frameMaps.getSecond();
        HashSet<RuntimeFrameRx> ambiguousRtFrames = new HashSet<RuntimeFrameRx>();
        HashSet<RuntimeFlow> rtFbFlowsAffected = new HashSet<RuntimeFlow>();
        for (InterfaceFrame frameMapKey : indistinguishableFrameMap.keySet()) {
            RuntimeFrameRx conflictingFrame = frameMapKey.getFrame();
            ambiguousRtFrames.add(conflictingFrame);
            rtFbFlowsAffected.add(conflictingFrame.getRuntimeFlow());
        }
        this.addContentFilter(ambiguousRtFrames);
        for (RuntimeFlow rtFbFlow : this.rtFbFlowsConfigured) {
            rtFbFlow.updateFilters();
        }
        Pair<MultiValueMap, MultiValueMap> frameMapsImproved = this.fillCollidingFrameMaps2();
        MultiValueMap identicalFrameMapImproved = (MultiValueMap)frameMapsImproved.getFirst();
        MultiValueMap indistinguishableFrameMapImproved = (MultiValueMap)frameMapsImproved.getSecond();
        if (identicalFrameMap.size() != identicalFrameMapImproved.size()) {
            throw new IllegalStateException("Adding a content filter does not affect identical frames");
        }
        ((Listener)this.getListener()).onFiltersImproved(this.rtScenario, identicalFrameMapImproved, indistinguishableFrameMapImproved);
        this.generateExceptions(identicalFrameMapImproved, indistinguishableFrameMapImproved);
    }

    private ByteBuffer getFilterablePayload(BPFFilter.Proto protocol, RuntimeFrame frame) {
        byte[] srcData = frame.hasFrameSizeModifier() ? frame.getPayload(protocol, frame.getFrameSizeModifier()) : frame.getPayload(protocol);
        ByteBuffer filterBytes = ByteBuffer.wrap(srcData);
        int lostPart = this.overwrittenPortionCache.computeIfAbsent(frame, newFrame -> {
            int lostBytes = 0;
            for (FrameTagTx tag : newFrame.getRuntimeFlow().getFrameTags()) {
                lostBytes = Math.max((int)tag.PositionGet(), lostBytes);
            }
            return lostBytes;
        });
        int minLength = filterBytes.limit() - lostPart;
        if (minLength >= 0 && minLength != filterBytes.capacity()) {
            filterBytes.limit(minLength);
        }
        return filterBytes;
    }

    private Pair<MultiValueMap, MultiValueMap> fillCollidingFrameMaps2() {
        MultiValueMap identicalFrameMap = MultiValueMap.decorate(new HashMap(), HashSet.class);
        MultiValueMap ambiguousFrameMap = MultiValueMap.decorate(new HashMap(), HashSet.class);
        MultiValueMap sameInterface = MultiValueMap.decorate(new HashMap(), ArrayList.class);
        for (RuntimePort port : this.rtScenario.getRuntimePortsConfigured()) {
            RuntimeInterface ifs = port.getRuntimeInterface();
            for (RuntimeFrame runtimeFrame : port.getRxFrames()) {
                sameInterface.put((Object)ifs, (Object)runtimeFrame);
            }
        }
        for (RuntimePort rtInterface : sameInterface.keySet()) {
            Collection frames = sameInterface.getCollection((Object)rtInterface);
            for (RuntimeFrameRx runtimeFrameRx : frames) {
                Filter lhsFilter = runtimeFrameRx.getFilterWithLength();
                ByteBuffer lhsBytes = this.getFilterablePayload(BPFFilter.Proto.ETHERNET, runtimeFrameRx);
                for (RuntimeFrameRx rFrame : frames) {
                    if (runtimeFrameRx == rFrame) continue;
                    Filter rhsFilter = rFrame.getFilterWithLength();
                    ByteBuffer rhsBytes = this.getFilterablePayload(BPFFilter.Proto.ETHERNET, rFrame);
                    if (runtimeFrameRx.getRuntimeFlow() == rFrame.getRuntimeFlow() || lhsFilter.excludes(rhsFilter)) continue;
                    MultiValueMap target = lhsBytes.equals(rhsBytes) ? identicalFrameMap : ambiguousFrameMap;
                    this.storeFrameConflict(target, (RuntimeInterface)((Object)rtInterface), runtimeFrameRx, rFrame);
                }
            }
        }
        return new Pair((Object)identicalFrameMap, (Object)ambiguousFrameMap);
    }

    private void storeFrameConflict(MultiValueMap target, RuntimeInterface arrivalRtIf, RuntimeFrameRx ... conflictFrames) {
        int ctr1 = 0;
        while (ctr1 < conflictFrames.length) {
            RuntimeFrameRx first = conflictFrames[ctr1];
            InterfaceFrame arrivingFrame = new InterfaceFrame(arrivalRtIf, first);
            int ctr2 = 0;
            while (ctr2 < conflictFrames.length) {
                if (ctr1 != ctr2) {
                    RuntimeFrameRx second = conflictFrames[ctr2];
                    target.put((Object)arrivingFrame, (Object)second);
                }
                ++ctr2;
            }
            ++ctr1;
        }
    }

    private boolean addContentFilter(Set<RuntimeFrameRx> ambiguousRtFrames) {
        MultiValueMap frameSizes = new MultiValueMap();
        for (RuntimeFrameRx rtFrame : ambiguousRtFrames) {
            int frameSize = rtFrame.getFrameLength();
            frameSizes.put((Object)frameSize, (Object)rtFrame);
        }
        boolean addedContentFilter = false;
        for (Object size : frameSizes.keySet()) {
            Collection sameSizeFrames = frameSizes.getCollection(size);
            if (sameSizeFrames.size() <= 1) continue;
            addedContentFilter |= this.addContentFilterToSameSizeRuntimeFrames(sameSizeFrames);
        }
        return addedContentFilter;
    }

    private boolean addContentFilterToSameSizeRuntimeFrames(Collection<RuntimeFrameRx> ambiguousFrames) {
        BPFFilter.Proto protocolToFilterOn = this.getProtocolToFilterOn(ambiguousFrames);
        boolean addedContentFilter = false;
        int i = 1;
        while (i <= 4) {
            List<ByteBuffer> payloads = this.getPayloadsFromFrames(protocolToFilterOn, ambiguousFrames);
            List<Integer> subset = ImproveFilters.findIndentifyingSubSet(payloads, i, 5000L);
            if (!subset.isEmpty()) {
                for (RuntimeFrameRx rtFrame : ambiguousFrames) {
                    rtFrame.addContentFilter(protocolToFilterOn, subset);
                }
                addedContentFilter = true;
                break;
            }
            ++i;
        }
        return addedContentFilter;
    }

    private BPFFilter.Proto getProtocolToFilterOn(Collection<RuntimeFrameRx> ambiguousFrames) {
        RuntimeFrameRx firstFrame = ambiguousFrames.iterator().next();
        BPFFilter.Proto proto = firstFrame.getHighestProtocol();
        return proto;
    }

    private List<ByteBuffer> getPayloadsFromFrames(BPFFilter.Proto protocol, Collection<RuntimeFrameRx> runtimeFrames) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (RuntimeFrame runtimeFrame : runtimeFrames) {
            ByteBuffer g = this.getFilterablePayload(protocol, runtimeFrame);
            result.add(g);
        }
        return result;
    }

    private static boolean hasDuplicates(List<ByteBuffer> buffers, List<Integer> subset) {
        TreeSet<ByteBuffer> result = new TreeSet<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            byte[] data = new byte[subset.size()];
            int i = 0;
            while (i < subset.size()) {
                data[i] = buffer.get(subset.get(i));
                ++i;
            }
            result.add(ByteBuffer.wrap(data));
        }
        return result.size() != buffers.size();
    }

    public static List<Integer> findIndentifyingSubSet(List<ByteBuffer> buffers, int subSetLength, long timeLimitMs) {
        long startTime = System.currentTimeMillis();
        int shortestBufferLength = ImproveFilters.getShortestBufferLength(buffers);
        if (shortestBufferLength == 0) {
            return Collections.EMPTY_LIST;
        }
        Interval interval = new Interval(Integer.valueOf(0), Integer.valueOf(shortestBufferLength - 1));
        SubSetIterator it = new SubSetIterator(interval, subSetLength);
        while (it.hasNext() && System.currentTimeMillis() - startTime < timeLimitMs) {
            ArrayList subset = it.next();
            if (ImproveFilters.hasDuplicates(buffers, subset)) continue;
            return subset;
        }
        return Collections.EMPTY_LIST;
    }

    private static int getShortestBufferLength(List<ByteBuffer> ByteBuffers) {
        int result = Integer.MAX_VALUE;
        for (ByteBuffer buffer : ByteBuffers) {
            result = Math.min(result, buffer.limit());
        }
        return result;
    }

    public static class InterfaceFrame {
        private final RuntimeInterface bbInterface;
        private final RuntimeFrameRx frame;

        private InterfaceFrame(RuntimeInterface bbInterface, RuntimeFrameRx frame) {
            this.bbInterface = bbInterface;
            this.frame = frame;
        }

        public RuntimeInterface getBbInterface() {
            return this.bbInterface;
        }

        public RuntimeFrameRx getFrame() {
            return this.frame;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof InterfaceFrame) {
                InterfaceFrame oth = (InterfaceFrame)obj;
                return this.bbInterface.equals(oth.bbInterface) && this.frame.equals(oth.frame);
            }
            return false;
        }

        public int hashCode() {
            return this.bbInterface.hashCode() + this.frame.hashCode();
        }
    }

    public static interface Listener {
        public void onFiltersImproved(RuntimeScenario var1, MultiValueMap var2, MultiValueMap var3);
    }
}

