/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.ResponseTimeout;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.ConfigureFlows;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.ConfigurePorts;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.CreateFlows;
import com.excentis.products.byteblower.run.actions.CreatePort;
import com.excentis.products.byteblower.run.actions.CreatePorts;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.ImproveFilters;
import com.excentis.products.byteblower.run.actions.SendScoutingFrames;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.core.runtime.IProgressMonitor;

public final class InitializeScenario
extends ConcreteAction<Listener>
implements CreatePorts.Listener,
ConfigurePorts.Listener,
CreateFlows.Listener,
ConfigureFlows.Listener,
ImproveFilters.Listener,
SendScoutingFrames.Listener,
CreateServer.Listener,
CreatePort.Listener,
ConfigurePort.Listener,
CreateFlow.Listener,
ConfigureFlow.Listener {
    private final RuntimeScenario rtScenario;
    private final IProgressMonitor progressMonitor;

    public static AbstractAction create(Context context, RuntimeScenario rtScenario, IProgressMonitor progressMonitor) {
        return context.decorate(new InitializeScenario(context, rtScenario, progressMonitor));
    }

    private InitializeScenario(Context context, RuntimeScenario rtScenario, IProgressMonitor progressMonitor) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public String getDescription() {
        return "Initialize scenario";
    }

    @Override
    public void invokeImpl() {
        try {
            ((Listener)this.getListener()).onScenarioInitializeStarting(this.rtScenario);
            this.getContext().listen(CreateServer.Listener.class, this);
            this.getContext().listen(CreatePort.Listener.class, this);
            this.getContext().listen(ConfigurePort.Listener.class, this);
            this.getContext().listen(ConfigureFlow.Listener.class, this);
            this.getContext().listen(CreateFlow.Listener.class, this);
            CreatePorts.create(this.getContext(), this.rtScenario).invoke();
            ConfigurePorts.create(this.getContext(), this.rtScenario).invoke();
            CreateFlows.create(this.getContext(), this.rtScenario).invoke();
            ConfigureFlows.create(this.getContext(), this.rtScenario).invoke();
            ImproveFilters.create(this.getContext(), this.rtScenario).invoke();
            if (this.rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().isEnableScoutingFrames()) {
                SendScoutingFrames.create(this.getContext(), this.rtScenario).invoke();
            }
            for (RuntimeFlow flow : this.rtScenario.getRuntimeFlows()) {
                flow.doMobileActions();
            }
            for (RuntimePort port : this.rtScenario.getRuntimePortsInvolved()) {
                WirelessEndpoint device = port.getMobilePort();
                if (device == null) continue;
                try {
                    device.Prepare();
                }
                catch (ConfigError | ResponseTimeout ex) {
                    String reason;
                    System.out.println(ex.getMessage());
                    device.Refresh();
                    long lastHeartBeat = device.MeetingPointGet().TimestampGet() - device.HeartbeatTimestampLastGet();
                    if (lastHeartBeat > 4000000000L) {
                        reason = String.format("Device can't contact its MeetingPoint for some time already (%d sec).", TimeUnit.NANOSECONDS.toSeconds(lastHeartBeat));
                    } else {
                        DeviceStatus state = device.StatusGet();
                        reason = "The status is " + state + ".";
                    }
                    String errorFmt = "Wireless Endpoint '%s' is not reachable. %s \n";
                    if (ex.getMessage() != null) {
                        errorFmt = String.valueOf(errorFmt) + ex.getMessage();
                    }
                    String error = String.format(errorFmt, device.DeviceInfoGet().GivenNameGet(), reason);
                    this.getContext().bellman(CreatePort.Listener.class).onPortCreationFailed(port, error);
                    throw new UserFriendlyInitializationError((AbstractAction)this, new RuntimeInitializationError(error));
                }
            }
            ((Listener)this.getListener()).onScenarioInitializeFinished(this.rtScenario);
        }
        catch (CancellationTriggered cancelEx) {
            ((Listener)this.getListener()).onScenarioInitializeCancelled(this.rtScenario);
            throw cancelEx;
        }
        catch (Exception initEx) {
            ((Listener)this.getListener()).onScenarioInitializeFailed(this.rtScenario, initEx.getMessage());
            throw initEx;
        }
    }

    @Override
    public void onPortsCreated(RuntimeScenario rtScenario) {
    }

    @Override
    public void onPortsConfigured(RuntimeScenario rtScenario) {
    }

    @Override
    public void onFlowsCreated(RuntimeScenario rtScenario) {
    }

    @Override
    public void onFlowsConfigured(RuntimeScenario rtScenario) {
    }

    @Override
    public void onFiltersImproved(RuntimeScenario rtScenario, MultiValueMap rtFbFramesIdentical, MultiValueMap rtFbFramesIndistinguishable) {
    }

    @Override
    public void onScoutingFramesSent(RuntimeScenario rtScenario) {
    }

    @Override
    public void onServerCreated(RuntimeBBServer rtServer) {
        this.processWorked(5);
    }

    @Override
    public void onServerCreationFailed(String serverUrl, CreateServer.Listener.ErrorType errorType, String errorMessage) {
        this.processWorked(5);
    }

    @Override
    public void onPortCreated(RuntimePort rtPort) {
        this.processWorked(1);
    }

    @Override
    public void onPortCreationFailed(RuntimePort rtPort, String errorMessage) {
        this.processWorked(1);
    }

    @Override
    public void onPortConfiguring(RuntimePort rtPort) {
    }

    @Override
    public void onPortConfigured(RuntimePort rtPort) {
        this.processWorked(2);
    }

    @Override
    public void onPortConfigurationFailed(RuntimePort rtPort, String errorMessage) {
        this.processWorked(2);
    }

    @Override
    public void onFlowCreated(RuntimeFlow rtFlow) {
        this.processWorked(1);
    }

    @Override
    public void onFlowCreationFailed(FlowMeasurement mFlowInstance, String errorMessage) {
        this.processWorked(1);
    }

    public void onFlowConfiguring(RuntimeFlow rtFlow) {
    }

    @Override
    public void onFlowConfigured(RuntimeFlow rtFlow) {
        this.processWorked(2);
    }

    @Override
    public void onFlowConfigurationFailed(RuntimeFlow rtFlow, String errorMessage) {
        this.processWorked(2);
    }

    private void processWorked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
        }
    }

    public static interface Listener {
        public void onScenarioInitializeStarting(RuntimeScenario var1);

        public void onScenarioInitializeFinished(RuntimeScenario var1);

        public void onScenarioInitializeCancelled(RuntimeScenario var1);

        public void onScenarioInitializeFailed(RuntimeScenario var1, String var2);
    }
}

