/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.IGMPMemberSession;
import com.excentis.products.byteblower.communication.api.IGMPv1MemberSession;
import com.excentis.products.byteblower.communication.api.IGMPv2MemberSession;
import com.excentis.products.byteblower.communication.api.IGMPv3MemberSession;
import com.excentis.products.byteblower.communication.api.MLDMulticastListenerSession;
import com.excentis.products.byteblower.communication.api.MLDv1MulticastListenerSession;
import com.excentis.products.byteblower.communication.api.MLDv2MulticastListenerSession;
import com.excentis.products.byteblower.communication.api.MulticastSourceFilter;
import com.excentis.products.byteblower.communication.api.StringList;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeIgmpSession;
import com.excentis.products.byteblower.run.objects.RuntimeMldSession;
import com.excentis.products.byteblower.run.objects.RuntimeMulticastDestination;
import com.excentis.products.byteblower.run.objects.RuntimeMulticastSession;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.HashSet;

abstract class MulticastAction<Listener>
extends ConcreteAction<Listener> {
    protected final RuntimeScenario rtScenario;

    protected MulticastAction(Context context, Class<Listener> listenerClass, RuntimeScenario rtScenario) {
        super(context, listenerClass);
        this.rtScenario = rtScenario;
    }

    protected void performMulticastAction(MulticastActionType actionType) {
        HashSet<RuntimeMulticastSession> multicastSessions = new HashSet<RuntimeMulticastSession>();
        for (RuntimeFlow rtFlow : this.rtScenario.getRuntimeFlowsConfigured()) {
            if (!(rtFlow.getRuntimeFlowDestination() instanceof RuntimeMulticastDestination)) continue;
            RuntimeMulticastDestination rtMulticastDest = (RuntimeMulticastDestination)rtFlow.getRuntimeFlowDestination();
            MulticastGroup mMulticastGroup = rtMulticastDest.getModelMulticastGroup();
            for (RuntimePort rtPort : rtMulticastDest.getRuntimePorts()) {
                if (rtPort.getState() != RuntimePort.State.CONFIGURED) continue;
                multicastSessions.add(rtPort.getRuntimeLayer3Configuration().findRuntimeMulticastSession(mMulticastGroup));
            }
        }
        for (RuntimeMulticastSession rtMulticastSession : multicastSessions) {
            if (rtMulticastSession.isIpv4()) {
                this.performIpv4MulticastAction(actionType, (RuntimeIgmpSession)rtMulticastSession);
                continue;
            }
            if (rtMulticastSession.isIpv6()) {
                this.performIpv6MulticastAction(actionType, (RuntimeMldSession)rtMulticastSession);
                continue;
            }
            throw new IllegalStateException("Multicast session is neither IPv4 or IPv6");
        }
    }

    private void performIpv4MulticastAction(MulticastActionType actionType, RuntimeIgmpSession rtIgmpSession) {
        block13: {
            IGMPMemberSession apiIgmpMemberSession;
            block15: {
                block14: {
                    block12: {
                        apiIgmpMemberSession = rtIgmpSession.getApiSession();
                        if (!(apiIgmpMemberSession instanceof IGMPv1MemberSession)) break block12;
                        switch (actionType) {
                            case START_LISTENING: {
                                ((IGMPv1MemberSession)apiIgmpMemberSession).Join();
                                break block13;
                            }
                            case STOP_LISTENING: {
                                ((IGMPv1MemberSession)apiIgmpMemberSession).Leave();
                                break block13;
                            }
                            default: {
                                throw new IllegalStateException("Unsupported Multicast operation");
                            }
                        }
                    }
                    if (!(apiIgmpMemberSession instanceof IGMPv2MemberSession)) break block14;
                    switch (actionType) {
                        case START_LISTENING: {
                            ((IGMPv2MemberSession)apiIgmpMemberSession).Join();
                            break block13;
                        }
                        case STOP_LISTENING: {
                            ((IGMPv2MemberSession)apiIgmpMemberSession).Leave();
                            break block13;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported Multicast operation");
                        }
                    }
                }
                if (!(apiIgmpMemberSession instanceof IGMPv3MemberSession)) break block15;
                switch (actionType) {
                    case START_LISTENING: {
                        ((IGMPv3MemberSession)apiIgmpMemberSession).MulticastListen(rtIgmpSession.getApiSourceFilter(), rtIgmpSession.getSourceGroupIpAddressesApiStringList());
                        break block13;
                    }
                    case STOP_LISTENING: {
                        ((IGMPv3MemberSession)apiIgmpMemberSession).MulticastListen(MulticastSourceFilter.Include, new StringList());
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported Multicast operation");
                    }
                }
            }
            throw new IllegalStateException("Unsupported IGMP session version " + apiIgmpMemberSession.getClass());
        }
    }

    private void performIpv6MulticastAction(MulticastActionType actionType, RuntimeMldSession rtMldSession) {
        block9: {
            MLDMulticastListenerSession apiMldMulticastListenerSession;
            block10: {
                block8: {
                    apiMldMulticastListenerSession = rtMldSession.getApiSession();
                    if (!(apiMldMulticastListenerSession instanceof MLDv1MulticastListenerSession)) break block8;
                    switch (actionType) {
                        case START_LISTENING: {
                            ((MLDv1MulticastListenerSession)apiMldMulticastListenerSession).ListeningStart();
                            break block9;
                        }
                        case STOP_LISTENING: {
                            ((MLDv1MulticastListenerSession)apiMldMulticastListenerSession).ListeningStop();
                            break block9;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported Multicast operation");
                        }
                    }
                }
                if (!(apiMldMulticastListenerSession instanceof MLDv2MulticastListenerSession)) break block10;
                switch (actionType) {
                    case START_LISTENING: {
                        ((MLDv2MulticastListenerSession)apiMldMulticastListenerSession).MulticastListen(rtMldSession.getApiSourceFilter(), rtMldSession.getSourceGroupIpAddressesApiStringList());
                        break block9;
                    }
                    case STOP_LISTENING: {
                        ((MLDv2MulticastListenerSession)apiMldMulticastListenerSession).MulticastListen(MulticastSourceFilter.Include, new StringList());
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported Multicast operation");
                    }
                }
            }
            throw new IllegalStateException("Unsupported MLD session version " + apiMldMulticastListenerSession.getClass());
        }
    }

    protected static enum MulticastActionType {
        START_LISTENING,
        STOP_LISTENING;

    }
}

