/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.actions.Wait;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.util.ArrayList;
import java.util.function.Supplier;

public final class ResetFlowReceivers
extends ConcreteAction<Listener> {
    private final RuntimeScenario rtScenario;
    private String currentFlowDescription;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new ResetFlowReceivers(context, rtScenario));
    }

    private ResetFlowReceivers(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.currentFlowDescription = "";
    }

    private void workingOn(RuntimeFbFlow flow) {
        this.currentFlowDescription = String.format("'%s'", flow.name());
    }

    private void workingOn(RuntimePort port) {
        this.currentFlowDescription = String.format("'%s'", port.getName());
    }

    private void workDone() {
        this.currentFlowDescription = "";
    }

    @Override
    public String getDescription() {
        return "Resetting " + this.currentFlowDescription + " packet receivers";
    }

    @Override
    public void invokeImpl() {
        ArrayList<Supplier<Boolean>> cleanupTasks = new ArrayList<Supplier<Boolean>>();
        for (RuntimePort port : this.rtScenario.getRuntimePortsConfigured()) {
            cleanupTasks.add(port.prepareForTestRun());
        }
        boolean cleanupOK = false;
        while (!cleanupOK) {
            Wait.create(this.getContext(), 33L, "Byteblower Ports cleaning up Scenario Configuration");
            cleanupOK = cleanupTasks.stream().allMatch(val -> (Boolean)val.get());
        }
        for (RuntimeFbFlow rtFbFlow : this.rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.workingOn(rtFbFlow);
            rtFbFlow.resetResults();
        }
        for (RuntimePort port : this.rtScenario.getRuntimePortsInvolved()) {
            this.workingOn(port);
            port.resetResults();
        }
        for (DebugInfo info : this.rtScenario.collectDebugInfo()) {
            ((Listener)this.getListener()).onDebugInfo(info);
        }
        this.workDone();
        ((Listener)this.getListener()).onFlowReceiversReset(this.rtScenario);
    }

    public static interface Listener {
        public void onFlowReceiversReset(RuntimeScenario var1);

        public void onDebugInfo(DebugInfo var1);
    }
}

