/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResultList;
import com.excentis.products.byteblower.communication.api.TCPConnectionResetByPeer;
import com.excentis.products.byteblower.frame.Activator;
import com.excentis.products.byteblower.run.actions.StartScenario;
import com.excentis.products.byteblower.run.actions.StopScenario;
import com.excentis.products.byteblower.run.actions.StopTxTraffic;
import com.excentis.products.byteblower.run.actions.StopWirelessEndpoints;
import com.excentis.products.byteblower.run.actions.Wait;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public final class RunScenario
extends ConcreteAction<Listener>
implements StartScenario.Listener,
StopScenario.Listener {
    public static final int TOTAL_WAIT_WORK = 100;
    private static final long LONG_SCENARIO = TimeUnit.SECONDS.toNanos(30L);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("h:mm a");
    private static final long MINIMAL_WAIT_DURATION = TimeUnit.SECONDS.toNanos(1L);
    private static final long TIME_BASED_FLOW_GUARD_TIME = TimeUnit.SECONDS.toNanos(1L);
    private final RuntimeScenario rtScenario;
    private final IProgressMonitor progressMonitor;
    private final long timeBasedDuration;
    private int waitMonitorProgress = 0;
    private long waitTarget = 0L;
    private String description;

    private RunScenario(Context context, RuntimeScenario rtScenario, IProgressMonitor progressMonitor) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.progressMonitor = progressMonitor;
        long flowDurationTimeBased = rtScenario.getConfiguredFlowsDurationTimeBasedNs();
        long flowLastStartTime = rtScenario.getConfiguredFlowsLastStartTimeNs();
        this.timeBasedDuration = Math.max(flowDurationTimeBased, flowLastStartTime) + TIME_BASED_FLOW_GUARD_TIME;
        this.description = "Running scenario";
    }

    public static AbstractAction create(Context context, RuntimeScenario rtScenario, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        return context.decorate(new RunScenario(context, rtScenario, progressMonitor));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private void doWait(String description, long startTimeMs) {
        long startWaiting = this.now();
        long remaining = this.waitTarget - startWaiting;
        if (remaining > 0L) {
            Wait.create(this.getContext(), TimeUnit.NANOSECONDS.toMillis(remaining), description).invoke();
            this.waitTarget += MINIMAL_WAIT_DURATION;
        } else {
            long lostPeriods = (startWaiting - this.waitTarget) / MINIMAL_WAIT_DURATION;
            this.waitTarget += (lostPeriods + 1L) * MINIMAL_WAIT_DURATION;
            Wait.create(this.getContext(), 0L, description).invoke();
        }
        this.processWorked(this.calculateWaitWorkedTicksNeeded(startTimeMs));
    }

    private void refreshSnapshots() {
        long start = System.currentTimeMillis();
        try {
            RefreshableSet toRefresh = new RefreshableSet();
            for (RuntimeFlow flow : this.rtScenario.getRuntimeFlowsConfigured()) {
                flow.resultsToRefresh(toRefresh);
            }
            for (RuntimePort port : this.rtScenario.getRuntimePortsConfigured()) {
                port.resultsToRefresh(toRefresh);
            }
            AbstractRefreshableResultList refreshList = toRefresh.toApiList();
            this.rtScenario.getRuntimeByteBlower().getApiByteBlower().ResultsRefresh(refreshList);
        }
        catch (TCPConnectionResetByPeer e) {
            Logger.getGlobal().log(Level.WARNING, "Received TCP reset, bailing out", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        long duration = System.currentTimeMillis() - start;
        if ((double)duration > 1000.0) {
            String msgFmt = "Retrieving results from the ByteBlower Server takes unusually long: %.01f seconds";
            String msg = String.format(msgFmt, (double)duration / 1000.0);
            Logger.getGlobal().log(Level.WARNING, String.format(msg, (double)duration / 1000.0));
        }
    }

    private void doScenarioUpdate() {
        this.refreshSnapshots();
        try {
            long start = System.currentTimeMillis();
            ((Listener)this.getListener()).onScenarioRunUpdate(this.rtScenario);
            long duration = System.currentTimeMillis() - start;
            if ((double)duration > 1000.0) {
                String msgFmt = "Listener takes unusually long: %.01f seconds";
                String msg = String.format(msgFmt, (double)duration / 1000.0);
                Activator.getDefault().getLog().log((IStatus)new Status(1, "com.excentis.products.byteblower.frame", msg));
                Logger.getGlobal().log(Level.WARNING, String.format(msgFmt, (double)duration / 1000.0));
            }
        }
        catch (TCPConnectionResetByPeer e) {
            Logger.getGlobal().log(Level.WARNING, "Received TCP reset, bailing out", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private long now() {
        return System.nanoTime();
    }

    private boolean hasRunningFlows() {
        Collection<RuntimeFlow> active = this.rtScenario.collectActiveFlows();
        return !active.isEmpty();
    }

    @Override
    public void invokeImpl() {
        try {
            this.getContext().listen(StartScenario.Listener.class, this);
            this.getContext().listen(StopScenario.Listener.class, this);
            ((Listener)this.getListener()).onScenarioRunStarting(this.rtScenario);
            StartScenario.create(this.getContext(), this.rtScenario).invoke();
            long startTime = this.now();
            Date startDate = new Date();
            this.doScenarioUpdate();
            this.waitMonitorProgress = 0;
            long duration = this.expectedDuration();
            this.waitTarget = this.now() + MINIMAL_WAIT_DURATION;
            while (this.hasRunningFlows() && this.now() - startTime < duration) {
                String endString = "";
                if (duration > LONG_SCENARIO) {
                    Date endMoment = new Date(startDate.getTime() + TimeUnit.NANOSECONDS.toMillis(duration));
                    String durationString = this.howLongMessage(endMoment);
                    endString = "Continuing for " + durationString + ". Estimated end at " + TIME_FORMAT.format(endMoment);
                }
                this.doWait(endString, startTime);
                this.doScenarioUpdate();
            }
            Collection<RuntimeFlow> active = this.rtScenario.collectActiveFlows();
            while (!active.isEmpty()) {
                this.doWait(this.summaryText(active), startTime);
                this.doScenarioUpdate();
                active = this.rtScenario.collectActiveFlows();
            }
            StopTxTraffic.create(this.getContext(), this.rtScenario).invoke();
            Wait.create(this.getContext(), 250L, "Receiving last traffic");
            StopScenario.create(this.getContext(), this.rtScenario).invoke();
            this.doScenarioUpdate();
            this.description = "Processing results";
            this.progressMonitor.setTaskName(this.description);
            this.refreshSnapshots();
            ((Listener)this.getListener()).onScenarioRunFinished(this.rtScenario);
        }
        catch (CancellationTriggered cancelEx) {
            Context.CancelCheck prevBehaviour = this.getContext().setCancelBehavior(Context.CancelCheck.DONT_CHECK);
            StopTxTraffic.create(this.getContext(), this.rtScenario).invoke();
            Wait.create(this.getContext(), 100L, "Receiving last traffic");
            this.doScenarioUpdate();
            StopScenario.create(this.getContext(), this.rtScenario).invoke();
            StopWirelessEndpoints.create(this.getContext(), this.rtScenario).invoke();
            this.getContext().setCancelBehavior(prevBehaviour);
            ((Listener)this.getListener()).onScenarioRunCancelled(this.rtScenario);
            throw cancelEx;
        }
        catch (Exception runEx) {
            try {
                this.doScenarioUpdate();
            }
            catch (Exception ex) {
                Logger.getGlobal().log(Level.WARNING, "Can't perform last refresh", ex);
            }
            ((Listener)this.getListener()).onScenarioRunFailed(this.rtScenario, runEx.getMessage());
            throw runEx;
        }
    }

    private String howLongMessage(Date endMoment) {
        Date now = new Date();
        Duration howLong = Duration.of(endMoment.getTime() - now.getTime(), ChronoUnit.MILLIS);
        ChronoUnit[] displayUnits = new ChronoUnit[]{ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};
        StringBuilder builder = new StringBuilder();
        String sep = "";
        long remaining = howLong.get(ChronoUnit.SECONDS);
        ChronoUnit[] chronoUnitArray = displayUnits;
        int n = displayUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ChronoUnit unit = chronoUnitArray[n2];
            long remainingTimeInUnit = unit.getDuration().get(ChronoUnit.SECONDS);
            if (remainingTimeInUnit < remaining) {
                String f = String.format("%d %s", remaining / remainingTimeInUnit, unit.toString());
                remaining %= remainingTimeInUnit;
                builder.append(sep);
                builder.append(f);
                sep = ", ";
            }
            ++n2;
        }
        return builder.toString();
    }

    private String summaryText(Collection<RuntimeFlow> active) {
        if (active.size() == 1) {
            RuntimeFlow first = active.iterator().next();
            return String.format("Waiting on %s", first.description());
        }
        StringBuilder description = new StringBuilder();
        String sep = "";
        int flowCtr = 0;
        for (RuntimeFlow flow : active) {
            if (flowCtr < 3 || flowCtr + 1 == active.size()) {
                description.append(sep);
                description.append(flow.name());
            } else if (flowCtr == 4) {
                description.append(" ... ");
            }
            sep = ", ";
            ++flowCtr;
        }
        return String.format("%d flows active: %s", active.size(), description);
    }

    @Override
    public void onScenarioStarted(RuntimeScenario rtScenario) {
        this.processWorked(1);
    }

    @Override
    public void onScenarioStopped(RuntimeScenario rtScenario) {
        this.processWorked(1);
    }

    private long expectedDuration() {
        return Math.max(this.timeBasedDuration, this.rtScenario.getConfiguredFlowsDurationFbNs());
    }

    private int calculateWaitWorkedTicksNeeded(long startTime) {
        double httpSizeFlowProgress;
        int oldWaitMonitorProgress = this.waitMonitorProgress;
        if (oldWaitMonitorProgress >= 100) {
            return 0;
        }
        long timeFlowWaitDuration = Math.max(1L, this.expectedDuration());
        long alreadyRunning = this.now() - startTime;
        double timeFlowProgress = (double)alreadyRunning / (double)timeFlowWaitDuration;
        double progress = Math.min(timeFlowProgress, httpSizeFlowProgress = 1.0);
        int actualWaitMonitorProgress = (int)Math.floor(progress * 100.0);
        if (actualWaitMonitorProgress >= 100) {
            this.waitMonitorProgress = 100;
            return this.waitMonitorProgress - oldWaitMonitorProgress;
        }
        if (actualWaitMonitorProgress > oldWaitMonitorProgress) {
            this.waitMonitorProgress = actualWaitMonitorProgress;
            return this.waitMonitorProgress - oldWaitMonitorProgress;
        }
        return 0;
    }

    private void processWorked(int work) {
        this.progressMonitor.worked(work);
    }

    public static interface Listener {
        public void onScenarioRunStarting(RuntimeScenario var1);

        public void onScenarioRunUpdate(RuntimeScenario var1);

        public void onScenarioRunFinished(RuntimeScenario var1);

        public void onScenarioRunCancelled(RuntimeScenario var1);

        public void onScenarioRunFailed(RuntimeScenario var1, String var2);
    }
}

