/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.Frame;
import com.excentis.products.byteblower.communication.api.FrameMobile;
import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.utils.Sleep;
import com.excentis.products.byteblower.utils.Utils;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class SendScoutingFrames
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private final long interFrameGapNs;
    private final long initialTimeToWaitNs = 0L;
    private final long numberOfFrames = 1L;
    private final long streamLeadOutTimeMs = 100L;
    private final long processTimeMs = 1000L;
    private final RuntimeScenario rtScenario;

    private SendScoutingFrames(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.interFrameGapNs = rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().getScoutingInterFrameGapNs();
    }

    public static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new SendScoutingFrames(context, rtScenario));
    }

    @Override
    public String getDescription() {
        return "Send scouting frames";
    }

    @Override
    public void invokeImpl() {
        boolean hasScoutingFrames = false;
        for (RuntimePort port : this.rtScenario.getRuntimePorts()) {
            if (port.isMobile()) {
                hasScoutingFrames |= this.scoutingFrame((RuntimeMobileDevice)port);
                continue;
            }
            hasScoutingFrames |= this.scoutingFrame(port);
        }
        if (hasScoutingFrames) {
            Sleep.sleep((long)1000L);
            ((Listener)this.getListener()).onScoutingFramesSent(this.rtScenario);
        }
    }

    private boolean scoutingFrame(RuntimeMobileDevice port) {
        boolean hasScoutingFrames = false;
        for (RuntimeFrameTx frame : port.getOutgoingFrames()) {
            this.mobileScoutingFrame(port, frame);
        }
        return hasScoutingFrames;
    }

    private boolean scoutingFrame(RuntimePort port) {
        long numberOfFrames = port.getOutgoingFrames().size();
        if (numberOfFrames == 0L) {
            return false;
        }
        long interFrameGapMs = this.interFrameGapNs / 1000000L;
        ByteBlowerPort apiSrcPort = port.getApiPort();
        Stream apiTxStream = apiSrcPort.TxStreamAdd();
        for (RuntimeFrameTx frame : port.getOutgoingFrames()) {
            Frame apiTxFrame = apiTxStream.FrameAdd();
            apiTxFrame.BytesSet(frame.getByteHexString());
        }
        apiTxStream.InitialTimeToWaitSet(0L);
        apiTxStream.InterFrameGapSet(this.interFrameGapNs);
        apiTxStream.NumberOfFramesSet((long)port.getOutgoingFrames().size());
        apiTxStream.Start();
        Sleep.sleep((long)(interFrameGapMs * numberOfFrames + 100L));
        apiTxStream.Stop();
        apiSrcPort.TxStreamRemove(apiTxStream);
        return true;
    }

    private void mobileScoutingFrame(RuntimeMobileDevice source, RuntimeFrameTx frame) {
        if (frame.getHighestProtocol() != BPFFilter.Proto.UDP) {
            String errorMsg = String.format("Can only create scouting frame for UDP packets.\n  Received frame of type %s", frame.getHighestProtocol().name());
            throw new IllegalStateException(errorMsg);
        }
        UDPPacket udp = (UDPPacket)frame.getLayer(BPFFilter.Proto.UDP);
        int destinationPort = udp.getDestination();
        int sourcePort = udp.getSource();
        String address = frame.getDestinationIpAddress();
        WirelessEndpoint device = source.getMobilePort();
        StreamMobile stream = device.TxStreamAdd();
        stream.DestinationAddressSet(address);
        stream.SourcePortSet(sourcePort);
        stream.DestinationPortSet(destinationPort);
        stream.NumberOfFramesSet(1L);
        stream.InitialTimeToWaitSet(0L);
        stream.InterFrameGapSet(this.interFrameGapNs);
        FrameMobile apiFrame = stream.FrameAdd();
        ProtocolField protoPayload = udp.getPayload();
        int payloadSize = protoPayload.getSize() / 8;
        byte[] payload = new byte[payloadSize];
        protoPayload.dump(payload, 0);
        apiFrame.PayloadSet(Utils.bufferToHexString((byte[])payload));
        long MAX_DURATION = source.getHeartBeat(TimeUnit.NANOSECONDS);
        if (!source.executeScenario(MAX_DURATION, TimeUnit.NANOSECONDS, this.getContext())) {
            LOGGER.severe("Failed to transmit the scouting frames");
        }
        device.TxStreamRemove(stream);
    }

    public static interface Listener {
        public void onScoutingFramesSent(RuntimeScenario var1);
    }
}

