/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.TechnicalError;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServerTimeSynchronization
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final long MAX_MEASUREMENT_TIME = 750L;
    private static final long MAX_TRIALS = 11L;
    private static final int OUTLIER_PART = 3;
    private final RuntimeServer server;

    private ServerTimeSynchronization(Context context, RuntimeServer server) {
        super(context, Listener.class);
        this.server = server;
    }

    static AbstractAction create(Context context, RuntimeServer server) {
        return context.decorate(new ServerTimeSynchronization(context, server));
    }

    @Override
    public String getDescription() {
        return "Estimate the time difference between local machine and server";
    }

    private static long estimateAverageTimeDifference(SortedSet<Long> measurements) {
        long avgOffset = Long.MAX_VALUE;
        int measurementSize = measurements.size();
        int outlierCount = measurementSize / 3;
        int meanSamplesCount = measurementSize - 2 * outlierCount;
        Iterator measureIt = measurements.iterator();
        int minOutlierCtr = 0;
        while (minOutlierCtr < outlierCount) {
            measureIt.next();
            avgOffset = 0L;
            ++minOutlierCtr;
        }
        int meanCtr = 0;
        while (meanCtr < meanSamplesCount) {
            long val = (Long)measureIt.next();
            avgOffset += val;
            ++meanCtr;
        }
        return avgOffset / (long)Math.max(meanSamplesCount, 1);
    }

    @Override
    public void invokeImpl() {
        long start = System.currentTimeMillis();
        TreeSet<Long> measurements = new TreeSet<Long>();
        while ((long)measurements.size() < 11L && System.currentTimeMillis() - start < 750L) {
            long before = System.currentTimeMillis();
            long serverNanos = Long.MAX_VALUE;
            try {
                serverNanos = this.server.now();
            }
            catch (TechnicalError technicalError) {
                LOGGER.log(Level.WARNING, "Server does not support fetching time of day");
                break;
            }
            long roundtrip = System.currentTimeMillis() - before;
            long difference = (before + roundtrip / 2L) * 1000000L - serverNanos;
            measurements.add(difference);
        }
        ((Listener)this.getListener()).onServerTimeOffset(this.server, ServerTimeSynchronization.estimateAverageTimeDifference(measurements));
    }

    public static interface Listener {
        public void onServerTimeOffset(RuntimeServer var1, long var2);
    }
}

