/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.core;

import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Decorator;
import com.excentis.products.byteblower.run.actions.core.DefaultDecorator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class Context {
    private Decorator globalDecorator = new DefaultDecorator();
    private Map<String, Decorator> typeDecorator = new HashMap<String, Decorator>();
    private Map<Class<?>, Forwarder<?>> forwarders = new IdentityHashMap();
    private ICancelChecker cancelChecker;
    private CancelCheck cancelBehavior = CancelCheck.CHECK;

    public Context(ICancelChecker cancelChecker) {
        this.cancelChecker = cancelChecker;
    }

    public boolean isCancelled() {
        if (this.cancelBehavior.equals((Object)CancelCheck.CHECK)) {
            return this.cancelChecker.isCancelled();
        }
        return false;
    }

    public CancelCheck getCancelBehavior() {
        return this.cancelBehavior;
    }

    public CancelCheck setCancelBehavior(CancelCheck cancelBehavior) {
        CancelCheck previous = this.cancelBehavior;
        this.cancelBehavior = cancelBehavior;
        return previous;
    }

    public AbstractAction decorate(AbstractAction action) {
        Decorator result = this.globalDecorator.copy();
        String typeName = action.getClass().getName();
        if (this.typeDecorator.containsKey(typeName)) {
            result.appendDecorator(this.typeDecorator.get(typeName).copy());
        }
        result.getLastDecorator().setDecoratedAction(action);
        return result;
    }

    public <DecoratorType extends Decorator> DecoratorType addGlobalDecorator(Class<DecoratorType> decoratorType) {
        try {
            Decorator dec = (Decorator)decoratorType.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.globalDecorator.appendDecorator(dec);
            return (DecoratorType)dec;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public <ActionType extends ConcreteAction<?>, DecoratorType extends Decorator> DecoratorType addTypeDecorator(Class<ActionType> actionType, Class<DecoratorType> decoratorType) {
        try {
            Decorator dec = (Decorator)decoratorType.getConstructor(new Class[0]).newInstance(new Object[0]);
            Decorator prev = this.typeDecorator.get(actionType.getName());
            if (prev != null) {
                prev.appendDecorator(dec);
            } else {
                this.typeDecorator.put(actionType.getName(), dec);
            }
            return (DecoratorType)dec;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public <Listener> Listener bellman(Class<Listener> target) {
        Forwarder<Object> forward;
        if (this.forwarders.containsKey(target)) {
            forward = this.forwarders.get(target);
        } else {
            forward = new Forwarder<Listener>(target);
            this.forwarders.put(target, forward);
        }
        return (Listener)forward.getProxy();
    }

    public <Listener> void listen(Class<Listener> target, Listener spectator) {
        Forwarder<Object> forward;
        if (this.forwarders.containsKey(target)) {
            forward = this.forwarders.get(target);
        } else {
            forward = new Forwarder<Listener>(target);
            this.forwarders.put(target, forward);
        }
        forward.add(spectator);
    }

    public <Listener> void unlisten(Class<Listener> target, Listener spectator) {
        if (this.forwarders.containsKey(target)) {
            Forwarder<?> forward = this.forwarders.get(target);
            forward.remove(spectator);
        }
    }

    public static enum CancelCheck {
        CHECK,
        DONT_CHECK;

    }

    private static class Forwarder<Interface>
    implements InvocationHandler {
        private final List<Interface> interested = new ArrayList<Interface>();
        private final Interface proxy;

        public Forwarder(Class<Interface> target) {
            ClassLoader loader = target.getClassLoader();
            this.proxy = Proxy.newProxyInstance(loader, new Class[]{target}, (InvocationHandler)this);
        }

        public Interface getProxy() {
            return this.proxy;
        }

        public void add(Interface spectator) {
            this.interested.add(spectator);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Interface ifs : this.interested) {
                method.invoke(ifs, args);
            }
            return new Object();
        }

        public void remove(Interface spectator) {
            this.interested.remove(spectator);
        }
    }

    public static interface ICancelChecker {
        public boolean isCancelled();
    }
}

