/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.PortForwardingReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.DumbCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkProbe;
import com.excentis.products.byteblower.run.actions.natdiscovery.NATCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.PortMapDestination;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.TransportLayer;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;
import com.excentis.products.byteblower.run.actions.natdiscovery.VLAN;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.HashMap;
import java.util.Map;

public class AutoIPPortForward
implements NATCache {
    private DumbCache portCache = new DumbCache();
    private DumbCache ipCache = new DumbCache();
    private int probePort;
    private NatDiscovery.L4Protocol probeProtocol;
    private Map<PortMapDestination, Integer> portMappings = new HashMap<PortMapDestination, Integer>();

    public AutoIPPortForward(PortForwardingReader forwardReader) {
        this.probePort = Integer.valueOf(forwardReader.getAutomaticDiscoveryProbePortString());
        String strProtocol = forwardReader.getAutomaticDiscoveryProbeProtocolString();
        this.probeProtocol = NatDiscovery.L4Protocol.valueOf(strProtocol);
        for (PortMapping map : forwardReader.getPortMappings()) {
            PortMapDestination destination = new PortMapDestination(map.getProtocol().getName(), (int)map.getPrivatePort());
            this.portMappings.put(destination, map.getPublicPort());
        }
    }

    private boolean localResolution(LinkPath path) {
        PortMapDestination toSearch = new PortMapDestination(path.protocol(), path.getPort());
        return this.portMappings.containsKey(toSearch);
    }

    private LinkPath genProbePath(LinkPath src) {
        LinkPath probePath = new LinkPath(src);
        EndPoint.EndVisitor probeModifier = new EndPoint.EndVisitor(){

            @Override
            public void call(TCP t) {
            }

            @Override
            public void call(UDP u) {
            }

            @Override
            public void call(IPV4 i) {
                i.setPayload(TransportLayer.create(AutoIPPortForward.this.probeProtocol, AutoIPPortForward.this.probePort));
            }

            @Override
            public void call(VLAN v) {
            }

            @Override
            public void call(IPV6 i) {
                i.setPayload(TransportLayer.create(AutoIPPortForward.this.probeProtocol, AutoIPPortForward.this.probePort));
            }
        };
        probePath.getSourceEnd().visit(probeModifier);
        probePath.getDestinationEnd().visit(probeModifier);
        return probePath;
    }

    @Override
    public boolean isResolved(LinkPath path) {
        return this.localResolution(path) && this.ipCache.isResolved(this.genProbePath(path)) || this.portCache.isResolved(path);
    }

    @Override
    public LinkPath result(LinkPath path) {
        LinkPath result;
        if (this.localResolution(path)) {
            LinkPath probe = this.genProbePath(path);
            LinkPath probedResult = this.ipCache.result(probe);
            if (probedResult == null) {
                return null;
            }
            PortMapDestination toSearch = new PortMapDestination(path.protocol(), path.getPort());
            int pubPort = this.portMappings.get(toSearch);
            result = new LinkPath(path);
            EndPoint src = result.getSourceEnd();
            src.setIP4Address(probedResult.getSource());
            src.setPort(pubPort);
        } else {
            result = this.portCache.result(path);
        }
        return result;
    }

    @Override
    public LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest, FrameReader base) {
        LinkProbe probe;
        if (this.localResolution(path)) {
            LinkPath modified = this.genProbePath(path);
            probe = this.ipCache.createProbe(modified, src, dest);
        } else {
            probe = this.portCache.createProbe(path, src, dest, base);
        }
        return probe;
    }

    @Override
    public String createFilter(LinkPath path) {
        String result;
        if (this.localResolution(path)) {
            LinkPath modified = this.genProbePath(path);
            result = this.ipCache.createFilter(modified);
        } else {
            result = this.portCache.createFilter(path);
        }
        return result;
    }

    @Override
    public boolean resolve(LinkPath origLink, LinkProbe probe, byte[] probeResult) {
        boolean result;
        if (this.localResolution(origLink)) {
            LinkPath modified = this.genProbePath(origLink);
            result = this.ipCache.resolve(modified, probe, probeResult);
        } else {
            result = this.portCache.resolve(origLink, probe, probeResult);
        }
        return result;
    }

    @Override
    public NatDiscovery.NatDiscoveryParameters parameters(LinkPath origLink) {
        if (this.localResolution(origLink)) {
            return new NatDiscovery.NatDiscoveryParameters(NatDiscovery.IpType.AUTOMATIC_PUBLIC_IP_DISCOVERY, NatDiscovery.PortType.MANUAL_PUBLIC_PORT, this.probeProtocol);
        }
        return this.portCache.parameters(origLink);
    }
}

