/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;
import com.excentis.products.byteblower.run.actions.natdiscovery.VLAN;
import com.excentis.products.byteblower.run.objects.RuntimePort;

abstract class EndPoint {
    EndPoint() {
    }

    public abstract EndPoint deepCopy();

    public abstract NatDiscovery.L4Protocol getProtocol();

    public abstract void setIP4Address(String var1);

    public abstract void setPort(int var1);

    public abstract boolean equals(Object var1);

    public static EndPoint create(RuntimePort port, FrameReader baseFrame, Direction dir) {
        if (port.isRuntimeLayer25Empty()) {
            if (port.isRuntimeLayer3Ipv4()) {
                return new IPV4(port, baseFrame, dir);
            }
            if (port.isRuntimeLayer3Ipv6()) {
                return new IPV6(port, baseFrame, dir);
            }
            throw new IllegalStateException("NAT Discovery only for IPv4 or IPv6 packets");
        }
        return new VLAN(port, baseFrame, dir);
    }

    public static EndPoint create(RuntimePort port, NatDiscovery.L4Protocol protocol, int l4Port) {
        if (port.isRuntimeLayer25Empty()) {
            return new IPV4(port, protocol, l4Port);
        }
        return new VLAN(port, protocol, l4Port);
    }

    public void visit(EndVisitor v) {
        this.visit(v, true);
    }

    public abstract void visit(EndVisitor var1, boolean var2);

    public abstract int hashCode();

    public abstract String getSource();

    public abstract NatDiscovery.L4Protocol protocol();

    public abstract int getPort();

    static interface EndVisitor {
        public void call(VLAN var1);

        public void call(IPV4 var1);

        public void call(UDP var1);

        public void call(TCP var1);

        public void call(IPV6 var1);
    }
}

