/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.frame.VlanPacket;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;
import com.excentis.products.byteblower.run.actions.natdiscovery.VLAN;
import com.excentis.products.byteblower.run.objects.RuntimeEthernetIIConfiguration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public class LinkProbe {
    protected final String unique;
    private final EthernetPacket packet;

    private LinkProbe(EthernetPacket packet, String unique) {
        this.packet = packet;
        this.unique = unique;
    }

    static LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest, FrameReader base) {
        ProbeFactory factory = new ProbeFactory(src, dest, base);
        path.getDestinationEnd().visit(factory.destinationProbe());
        path.getSourceEnd().visit(factory.sourceProbe(), true);
        return factory.probe();
    }

    static LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest) {
        EmptyProbeFactory factory = new EmptyProbeFactory(src, dest);
        path.getDestinationEnd().visit(factory.destinationProbe());
        path.getSourceEnd().visit(factory.sourceProbe(), true);
        return factory.probe();
    }

    protected boolean same(byte[] result) {
        return Arrays.equals(result, this.unique.getBytes());
    }

    public EthernetPacket getPacket() {
        return this.packet;
    }

    private static class EmptyProbeFactory {
        private EthernetPacket packetEthernet;
        private int port;
        private RuntimePort srcPort;
        private RuntimePort destPort;
        private String probeMessage;

        public EmptyProbeFactory(RuntimePort src, RuntimePort dest) {
            this.srcPort = src;
            this.destPort = dest;
            this.probeMessage = "Excentis NAT discover id=" + new Random().nextInt();
        }

        EndPoint.EndVisitor destinationProbe() {
            return new EndPoint.EndVisitor(){

                @Override
                public void call(TCP t) {
                    port = t.getPort();
                }

                @Override
                public void call(UDP u) {
                    port = u.getPort();
                }

                @Override
                public void call(IPV4 i) {
                }

                @Override
                public void call(IPV6 i) {
                }

                @Override
                public void call(VLAN v) {
                }
            };
        }

        EndPoint.EndVisitor sourceProbe() {
            return new EndPoint.EndVisitor(){
                private Ipv4Packet ipv4;
                private Ipv6Packet ipv6;
                private VlanPacket vlan;
                boolean hasVLAN = false;

                private void sizes() {
                    if (this.ipv4 != null) {
                        this.ipv4.calcSize();
                        this.ipv4.autoSetLength();
                        this.ipv4.doCheckSum();
                    }
                    if (this.ipv6 != null) {
                        this.ipv6.calcSize();
                    }
                    if (this.vlan != null) {
                        this.vlan.calcSize();
                    }
                    if (packetEthernet != null) {
                        packetEthernet.calcSize();
                    }
                }

                @Override
                public void call(TCP t) {
                    TCPPacket tcp = new TCPPacket((ProtocolLayer)packetEthernet);
                    tcp.setPayload(probeMessage);
                    tcp.setSource(t.getPort());
                    tcp.setDestination(port);
                    tcp.setFlags("SYN");
                    tcp.setDataOffset(5);
                    this.ipv4.setProtocol(6);
                    this.ipv4.setPayload((ProtocolField)tcp);
                    this.sizes();
                }

                @Override
                public void call(UDP u) {
                    UDPPacket udp = new UDPPacket((ProtocolLayer)packetEthernet);
                    udp.setPayload(probeMessage);
                    udp.setSource(u.getPort());
                    udp.setDestination(port);
                    udp.autoSetLength();
                    udp.doCheckSum();
                    this.ipv4.setProtocol(17);
                    this.ipv4.setPayload((ProtocolField)udp);
                    this.sizes();
                }

                @Override
                public void call(IPV4 i) {
                    packetEthernet = new EthernetPacket();
                    packetEthernet.do_default();
                    packetEthernet.setSA(((RuntimeEthernetIIConfiguration)srcPort.getRuntimeLayer2Configuration()).getMacAddressString());
                    String resolvedMac = srcPort.resolve(destPort.getIPAddress(), true);
                    packetEthernet.setDA(resolvedMac);
                    packetEthernet.setType(2048);
                    this.ipv4 = new Ipv4Packet((ProtocolLayer)packetEthernet);
                    this.ipv4.do_default();
                    this.ipv4.setSourceAddress(srcPort.getIPAddress());
                    this.ipv4.setDestinationAddress(destPort.getIPAddress());
                    this.ipv4.doCheckSum();
                    packetEthernet.setPayload((ProtocolField)this.ipv4);
                    if (this.hasVLAN) {
                        this.vlanCreation();
                    }
                }

                @Override
                public void call(IPV6 i) {
                    packetEthernet = new EthernetPacket();
                    packetEthernet.do_default();
                    packetEthernet.setSA(((RuntimeEthernetIIConfiguration)srcPort.getRuntimeLayer2Configuration()).getMacAddressString());
                    String resolvedMac = srcPort.resolve(destPort.getIPAddress(), true);
                    packetEthernet.setDA(resolvedMac);
                    packetEthernet.setType(34525);
                    this.ipv6 = new Ipv6Packet((ProtocolLayer)packetEthernet);
                    this.ipv6.do_default();
                    this.ipv6.setSourceAddress(srcPort.getIPAddress());
                    this.ipv6.setDestinationAddress(destPort.getIPAddress());
                    packetEthernet.setPayload((ProtocolField)this.ipv6);
                    if (this.hasVLAN) {
                        this.vlanCreation();
                    }
                }

                @Override
                public void call(VLAN v) {
                    this.hasVLAN = true;
                }

                private void vlanCreation() {
                    Iterator<RuntimeLayer25Configuration> configs = srcPort.layer25ConfigurationInnerIterator();
                    while (configs.hasNext()) {
                        RuntimeLayer25Configuration config = configs.next();
                        if (!(config instanceof RuntimeVlanConfiguration)) continue;
                        this.vlan = new VlanPacket((ProtocolLayer)packetEthernet);
                        this.vlan.setProtocol((int)((short)packetEthernet.getType()));
                        this.vlan.setPayload(packetEthernet.getPayload());
                        RuntimeVlanConfiguration vlanOptions = (RuntimeVlanConfiguration)config;
                        this.vlan.setVID(vlanOptions.getVlanId());
                        this.vlan.setPCP(vlanOptions.getPriority());
                        this.vlan.setDE(vlanOptions.isDropEligible());
                        packetEthernet.setType(vlanOptions.getProtocolId());
                        packetEthernet.setPayload((ProtocolField)this.vlan);
                    }
                }
            };
        }

        LinkProbe probe() {
            LinkProbe probe = new LinkProbe(this.packetEthernet, this.probeMessage);
            return probe;
        }
    }

    private static class ProbeFactory {
        private EthernetPacket packetEthernet;
        private int port;
        private FrameReader baseFrame;
        private RuntimePort srcPort;
        private RuntimePort destPort;
        private String probeMessage;

        public ProbeFactory(RuntimePort src, RuntimePort dest, FrameReader base) {
            this.srcPort = src;
            this.destPort = dest;
            this.baseFrame = base;
            this.probeMessage = "Excentis NAT discovery for frame " + base.getName() + " id=" + new Random().nextInt();
        }

        EndPoint.EndVisitor destinationProbe() {
            return new EndPoint.EndVisitor(){

                @Override
                public void call(TCP t) {
                    port = t.getPort();
                }

                @Override
                public void call(UDP u) {
                    port = u.getPort();
                }

                @Override
                public void call(IPV4 i) {
                }

                @Override
                public void call(VLAN v) {
                }

                @Override
                public void call(IPV6 ipv6) {
                }
            };
        }

        EndPoint.EndVisitor sourceProbe() {
            return new EndPoint.EndVisitor(){
                boolean hasVLAN = false;
                private Ipv4Packet ipv4;
                private Ipv6Packet ipv6;
                private VlanPacket vlan;

                private void sizes() {
                    if (this.ipv4 != null) {
                        this.ipv4.calcSize();
                        this.ipv4.autoSetLength();
                    }
                    if (this.vlan != null) {
                        this.vlan.calcSize();
                    }
                    if (packetEthernet != null) {
                        packetEthernet.calcSize();
                    }
                }

                @Override
                public void call(TCP t) {
                    TCPPacket tcp = baseFrame.getCurrentTcp();
                    tcp.setPayload(probeMessage);
                    tcp.setSource(t.getPort());
                    tcp.setDestination(port);
                    this.sizes();
                }

                @Override
                public void call(UDP u) {
                    UDPPacket udp = baseFrame.getCurrentUdp();
                    udp.setPayload(probeMessage);
                    udp.setSource(u.getPort());
                    udp.setDestination(port);
                    udp.autoSetLength();
                    udp.doCheckSum();
                    this.sizes();
                }

                @Override
                public void call(IPV4 i) {
                    packetEthernet = baseFrame.getEthernet();
                    packetEthernet.setSA(srcPort.getMacAddressString());
                    String resolvedMac = srcPort.resolve(destPort.getIPAddress(), true);
                    packetEthernet.setDA(resolvedMac);
                    this.ipv4 = baseFrame.getIpv4();
                    this.ipv4.setSourceAddress(srcPort.getIPAddress());
                    this.ipv4.setDestinationAddress(destPort.getIPAddress());
                    this.ipv4.doCheckSum();
                    if (this.hasVLAN) {
                        this.vlanCreation();
                    }
                }

                @Override
                public void call(IPV6 src) {
                    packetEthernet = baseFrame.getEthernet();
                    packetEthernet.setSA(srcPort.getMacAddressString());
                    String resolvedMac = srcPort.resolve(destPort.getIPAddress(), true);
                    packetEthernet.setDA(resolvedMac);
                    this.ipv6 = baseFrame.getIpv6();
                    this.ipv6.setSourceAddress(srcPort.getIPAddress());
                    this.ipv6.setDestinationAddress(destPort.getIPAddress());
                    if (this.hasVLAN) {
                        this.vlanCreation();
                    }
                }

                @Override
                public void call(VLAN v) {
                    this.hasVLAN = true;
                }

                private void vlanCreation() {
                    EthernetPacket child = packetEthernet;
                    Iterator<RuntimeLayer25Configuration> configs = srcPort.layer25ConfigurationInnerIterator();
                    while (configs.hasNext()) {
                        RuntimeLayer25Configuration config = configs.next();
                        if (!(config instanceof RuntimeVlanConfiguration)) continue;
                        this.vlan = new VlanPacket(null);
                        this.vlan.setProtocol((int)((short)packetEthernet.getType()));
                        this.vlan.setPayload(packetEthernet.getPayload());
                        RuntimeVlanConfiguration vlanOptions = (RuntimeVlanConfiguration)config;
                        this.vlan.setVID(vlanOptions.getVlanId());
                        this.vlan.setPCP(vlanOptions.getPriority());
                        this.vlan.setDE(vlanOptions.isDropEligible());
                        packetEthernet.setType(vlanOptions.getProtocolId());
                        packetEthernet.setPayload((ProtocolField)this.vlan);
                        child.setParent((ProtocolLayer)this.vlan);
                        child = this.vlan;
                    }
                }
            };
        }

        LinkProbe probe() {
            LinkProbe probe = new LinkProbe(this.packetEthernet, this.probeMessage);
            return probe;
        }
    }
}

