/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class VLAN
extends EndPoint
implements Iterable<Short> {
    private List<Short> vlanIds;
    private EndPoint payload;

    VLAN(RuntimePort port, FrameReader baseFrame, Direction dir) {
        this.copyVlanIds(port);
        if (baseFrame.getLayer3Type() == FrameReader.Layer3Type.IPV4) {
            this.payload = new IPV4(port, baseFrame, dir);
        } else if (baseFrame.getLayer3Type() == FrameReader.Layer3Type.IPV6) {
            this.payload = new IPV6(port, baseFrame, dir);
        } else {
            throw new IllegalStateException("Unsupported layer3 type " + port.getRuntimeLayer3Configuration().getClass().getSimpleName());
        }
    }

    private VLAN(Collection<Short> vlanIds, EndPoint payload) {
        this.vlanIds = new ArrayList<Short>(vlanIds);
        this.payload = payload;
    }

    VLAN(RuntimePort port, NatDiscovery.L4Protocol protocol, int l4Port) {
        this.copyVlanIds(port);
        this.payload = new IPV4(port, protocol, l4Port);
    }

    private void copyVlanIds(RuntimePort port) {
        this.vlanIds = new ArrayList<Short>();
        Iterator<RuntimeLayer25Configuration> it = port.layer25ConfigurationOuterIterator();
        while (it.hasNext()) {
            RuntimeLayer25Configuration config = it.next();
            if (!(config instanceof RuntimeVlanConfiguration)) continue;
            RuntimeVlanConfiguration vlan = (RuntimeVlanConfiguration)config;
            this.vlanIds.add(vlan.getVlanId());
        }
    }

    @Override
    public void setPort(int source) {
        this.payload.setPort(source);
    }

    @Override
    public boolean equals(Object e) {
        if (e != null && e instanceof VLAN) {
            VLAN oth = (VLAN)e;
            return this.vlanIds.equals(oth.vlanIds) && this.payload.equals(oth.payload);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int vlanHash = 0;
        for (short vlan : this.vlanIds) {
            vlanHash += (vlan << 16) + vlan;
        }
        return vlanHash + this.payload.hashCode();
    }

    @Override
    public String getSource() {
        return this.payload.getSource();
    }

    @Override
    public NatDiscovery.L4Protocol protocol() {
        return this.payload.protocol();
    }

    @Override
    public int getPort() {
        return this.payload.getPort();
    }

    @Override
    public EndPoint deepCopy() {
        EndPoint depthClone = this.payload.deepCopy();
        VLAN oth = new VLAN(this.vlanIds, depthClone);
        return oth;
    }

    @Override
    public void setIP4Address(String sourceAddress) {
        this.payload.setIP4Address(sourceAddress);
    }

    @Override
    public NatDiscovery.L4Protocol getProtocol() {
        return this.payload.getProtocol();
    }

    @Override
    public void visit(EndPoint.EndVisitor v, boolean startBottom) {
        if (startBottom) {
            v.call(this);
        }
        this.payload.visit(v);
        if (!startBottom) {
            v.call(this);
        }
    }

    @Override
    public Iterator<Short> iterator() {
        return this.vlanIds.iterator();
    }

    public int getOverhead() {
        return 4 * this.vlanIds.size();
    }
}

