/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;

public final class FrameLengthFilter
extends BPFFilter {
    private int minLength;
    private int maxLength;

    public static FrameLengthFilter createLengthBetweenFilter(int minLength, int maxLength) {
        return new FrameLengthFilter(minLength, maxLength);
    }

    public static FrameLengthFilter createLengthEqualToFilter(int length) {
        return new FrameLengthFilter(length, length);
    }

    public static FrameLengthFilter createLengthLessThanOrEqualToFilter(int length) {
        return new FrameLengthFilter(Integer.MIN_VALUE, length);
    }

    public static FrameLengthFilter createLengthGreaterThanOrEqualToFilter(int length) {
        return new FrameLengthFilter(length, Integer.MAX_VALUE);
    }

    private FrameLengthFilter(int minLength, int maxLength) {
        super(BPFFilter.Proto.ETHERNET);
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter filter) {
        if (filter instanceof FrameLengthFilter) {
            FrameLengthFilter rhs = (FrameLengthFilter)filter;
            return this.minLength > rhs.maxLength || this.maxLength < rhs.minLength;
        }
        return false;
    }

    public String toString() {
        if (this.minLength == Integer.MIN_VALUE && this.maxLength == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        if (this.minLength == Integer.MIN_VALUE) {
            return String.format("len<=%d", this.maxLength);
        }
        if (this.maxLength == Integer.MAX_VALUE) {
            return String.format("len>=%d", this.minLength);
        }
        if (this.minLength != this.maxLength) {
            return String.format("len>=%d and len<=%d", this.minLength, this.maxLength);
        }
        return String.format("len=%d", this.minLength);
    }
}

