/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;

public final class VlanFilter
extends BPFFilter {
    private String vlan_id;

    public static VlanFilter createVlanFilter(String vlan_id) {
        return new VlanFilter(BPFFilter.Proto.VLAN, vlan_id);
    }

    private VlanFilter(BPFFilter.Proto l2_5Protocol, String vlan_id) {
        super(l2_5Protocol);
        this.vlan_id = vlan_id;
    }

    public String toString() {
        return String.format("%s %s", this.getProtocol().toString(), this.vlan_id);
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter filter) {
        if (filter instanceof VlanFilter) {
            VlanFilter rhs = (VlanFilter)filter;
            return !this.vlan_id.equals(rhs.vlan_id);
        }
        return false;
    }
}

