/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters.core;

import com.excentis.products.byteblower.run.filters.EthernetEthertypeFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.filters.core.Leaf;

public abstract class BPFFilter
extends Leaf {
    private Proto protocol;
    private Dir direction;

    protected BPFFilter(Proto protocol) {
        this.protocol = protocol;
        this.direction = Dir.UNDEFINED;
    }

    protected BPFFilter(Proto protocol, Dir direction) {
        this.protocol = protocol;
        this.direction = direction;
    }

    public Dir getDirection() {
        return this.direction;
    }

    public Proto getProtocol() {
        return this.protocol;
    }

    public Layer getLayer() {
        return this.protocol.getLayer();
    }

    @Override
    protected final boolean excludesLeafImpl(Filter filter) {
        if (filter instanceof BPFFilter) {
            BPFFilter rhs = (BPFFilter)filter;
            if (this.getLayer().equals((Object)rhs.getLayer())) {
                if (!this.getProtocol().equals((Object)rhs.getProtocol())) {
                    return true;
                }
                if (this.getDirection().equals((Object)Dir.UNDEFINED) || this.getDirection().equals((Object)rhs.getDirection())) {
                    return this.excludesBPFFilterImpl(filter);
                }
                return false;
            }
            if (this.getProtocol().equals((Object)Proto.ARP) && rhs.getLayer().getValue() >= Layer.LAYER4.getValue()) {
                return true;
            }
            if (this instanceof EthernetEthertypeFilter) {
                return this.excludesBPFFilterImpl(rhs);
            }
            if (filter instanceof EthernetEthertypeFilter) {
                return ((EthernetEthertypeFilter)filter).excludes(this);
            }
        }
        return false;
    }

    protected abstract boolean excludesBPFFilterImpl(Filter var1);

    public static enum Dir {
        UNDEFINED(""),
        SRC("src"),
        DST("dst"),
        SRC_OR_DST("src or dst"),
        SRC_AND_DST("src and dst");

        private String bpfString;

        private Dir(String bpfString) {
            this.bpfString = bpfString;
        }

        public String toString() {
            return this.bpfString;
        }
    }

    private static enum Layer {
        LAYER2(2),
        LAYER2_5(25),
        LAYER3(3),
        LAYER4(4);

        private int value;

        private Layer(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum Proto {
        ETHERNET("ether", Layer.LAYER2, 14),
        VLAN("vlan", Layer.LAYER2_5, 4),
        ARP("arp", Layer.LAYER3, 28),
        IPv4("ip", Layer.LAYER3, 20),
        IPv6("ip6", Layer.LAYER3, 40),
        UDP("udp", Layer.LAYER4, 8),
        TCP("tcp", Layer.LAYER4, 20);

        private final String bpfString;
        private final Layer layer;
        private final int headerSize;

        private Proto(String bpfString, Layer layer, int headerSize) {
            this.bpfString = bpfString;
            this.layer = layer;
            this.headerSize = headerSize;
        }

        public String toString() {
            return this.bpfString;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public int headerByteSize() {
            return this.headerSize;
        }
    }
}

